/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.CommandPlugin;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CommandPluginMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").isBinary(false).build();
    private static final MarshallingInfo<Integer> RESPONSECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseCode").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESPONSESTARTDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseStartDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESPONSEFINISHDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseFinishDateTime").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Output").isBinary(false).build();
    private static final MarshallingInfo<String> STANDARDOUTPUTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardOutputUrl").isBinary(false).build();
    private static final MarshallingInfo<String> STANDARDERRORURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardErrorUrl").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3Region").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3BucketName").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3KeyPrefix").isBinary(false).build();
    private static final CommandPluginMarshaller INSTANCE = new CommandPluginMarshaller();

    private CommandPluginMarshaller() {
    }

    public static CommandPluginMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CommandPlugin commandPlugin, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)commandPlugin, (String)"commandPlugin");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)commandPlugin.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.responseCode(), RESPONSECODE_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.responseStartDateTime(), RESPONSESTARTDATETIME_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.responseFinishDateTime(), RESPONSEFINISHDATETIME_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.output(), OUTPUT_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.standardOutputUrl(), STANDARDOUTPUTURL_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.standardErrorUrl(), STANDARDERRORURL_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.outputS3Region(), OUTPUTS3REGION_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.outputS3BucketName(), OUTPUTS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)commandPlugin.outputS3KeyPrefix(), OUTPUTS3KEYPREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

