/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceInformationMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> PINGSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PingStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTPINGDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastPingDateTime").isBinary(false).build();
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISLATESTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsLatestVersion").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformType").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformName").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformVersion").isBinary(false).build();
    private static final MarshallingInfo<String> ACTIVATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivationId").isBinary(false).build();
    private static final MarshallingInfo<String> IAMROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").isBinary(false).build();
    private static final MarshallingInfo<Instant> REGISTRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationDate").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IPAddress").isBinary(false).build();
    private static final MarshallingInfo<String> COMPUTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputerName").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTASSOCIATIONEXECUTIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAssociationExecutionDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSUCCESSFULASSOCIATIONEXECUTIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfulAssociationExecutionDate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ASSOCIATIONOVERVIEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationOverview").isBinary(false).build();
    private static final InstanceInformationMarshaller INSTANCE = new InstanceInformationMarshaller();

    private InstanceInformationMarshaller() {
    }

    public static InstanceInformationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceInformation instanceInformation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceInformation, (String)"instanceInformation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceInformation.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.pingStatusAsString(), PINGSTATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.lastPingDateTime(), LASTPINGDATETIME_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.agentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.isLatestVersion(), ISLATESTVERSION_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.platformTypeAsString(), PLATFORMTYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.platformName(), PLATFORMNAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.platformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.activationId(), ACTIVATIONID_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.iamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.registrationDate(), REGISTRATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.computerName(), COMPUTERNAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.associationStatus(), ASSOCIATIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.lastAssociationExecutionDate(), LASTASSOCIATIONEXECUTIONDATE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.lastSuccessfulAssociationExecutionDate(), LASTSUCCESSFULASSOCIATIONEXECUTIONDATE_BINDING);
            protocolMarshaller.marshall((Object)instanceInformation.associationOverview(), ASSOCIATIONOVERVIEW_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

