/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListCommandInvocationsRequestModelMarshaller {
    private static final MarshallingInfo<String> COMMANDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Details").isBinary(false).build();
    private static final ListCommandInvocationsRequestModelMarshaller INSTANCE = new ListCommandInvocationsRequestModelMarshaller();

    private ListCommandInvocationsRequestModelMarshaller() {
    }

    public static ListCommandInvocationsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListCommandInvocationsRequest listCommandInvocationsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listCommandInvocationsRequest), (String)"listCommandInvocationsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listCommandInvocationsRequest.commandId(), COMMANDID_BINDING);
            protocolMarshaller.marshall((Object)listCommandInvocationsRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)listCommandInvocationsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listCommandInvocationsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(listCommandInvocationsRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)listCommandInvocationsRequest.details(), DETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

