/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.PatchComplianceData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PatchComplianceDataMarshaller {
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();
    private static final MarshallingInfo<String> KBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KBId").isBinary(false).build();
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").isBinary(false).build();
    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Severity").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<Instant> INSTALLEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledTime").isBinary(false).build();
    private static final PatchComplianceDataMarshaller INSTANCE = new PatchComplianceDataMarshaller();

    private PatchComplianceDataMarshaller() {
    }

    public static PatchComplianceDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PatchComplianceData patchComplianceData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)patchComplianceData, (String)"patchComplianceData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)patchComplianceData.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.kbId(), KBID_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.severity(), SEVERITY_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.installedTime(), INSTALLEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

