/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceDataSyncItemMarshaller {
    private static final MarshallingInfo<String> SYNCNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Destination").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSYNCTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSyncTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSUCCESSFULSYNCTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfulSyncTime").isBinary(false).build();
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> SYNCCREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncCreatedTime").isBinary(false).build();
    private static final ResourceDataSyncItemMarshaller INSTANCE = new ResourceDataSyncItemMarshaller();

    private ResourceDataSyncItemMarshaller() {
    }

    public static ResourceDataSyncItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceDataSyncItem resourceDataSyncItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceDataSyncItem, (String)"resourceDataSyncItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceDataSyncItem.syncName(), SYNCNAME_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncItem.s3Destination(), S3DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncItem.lastSyncTime(), LASTSYNCTIME_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncItem.lastSuccessfulSyncTime(), LASTSUCCESSFULSYNCTIME_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncItem.lastStatusAsString(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncItem.syncCreatedTime(), SYNCCREATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

