/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ActivationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activation registers one or more on-premises servers or virtual machines (VMs) with AWS so that you can configure
 * those servers or VMs using Run Command. A server or VM that has been registered with AWS is called a managed
 * instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Activation implements StructuredPojo, ToCopyableBuilder<Activation.Builder, Activation> {
    private final String activationId;

    private final String description;

    private final String defaultInstanceName;

    private final String iamRole;

    private final Integer registrationLimit;

    private final Integer registrationsCount;

    private final Instant expirationDate;

    private final Boolean expired;

    private final Instant createdDate;

    private Activation(BuilderImpl builder) {
        this.activationId = builder.activationId;
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.registrationsCount = builder.registrationsCount;
        this.expirationDate = builder.expirationDate;
        this.expired = builder.expired;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The ID created by Systems Manager when you submitted the activation.
     * </p>
     * 
     * @return The ID created by Systems Manager when you submitted the activation.
     */
    public String activationId() {
        return activationId;
    }

    /**
     * <p>
     * A user defined description of the activation.
     * </p>
     * 
     * @return A user defined description of the activation.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A name for the managed instance when it is created.
     * </p>
     * 
     * @return A name for the managed instance when it is created.
     */
    public String defaultInstanceName() {
        return defaultInstanceName;
    }

    /**
     * <p>
     * The Amazon Identity and Access Management (IAM) role to assign to the managed instance.
     * </p>
     * 
     * @return The Amazon Identity and Access Management (IAM) role to assign to the managed instance.
     */
    public String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The maximum number of managed instances that can be registered using this activation.
     * </p>
     * 
     * @return The maximum number of managed instances that can be registered using this activation.
     */
    public Integer registrationLimit() {
        return registrationLimit;
    }

    /**
     * <p>
     * The number of managed instances already registered with this activation.
     * </p>
     * 
     * @return The number of managed instances already registered with this activation.
     */
    public Integer registrationsCount() {
        return registrationsCount;
    }

    /**
     * <p>
     * The date when this activation can no longer be used to register managed instances.
     * </p>
     * 
     * @return The date when this activation can no longer be used to register managed instances.
     */
    public Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Whether or not the activation is expired.
     * </p>
     * 
     * @return Whether or not the activation is expired.
     */
    public Boolean expired() {
        return expired;
    }

    /**
     * <p>
     * The date the activation was created.
     * </p>
     * 
     * @return The date the activation was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(registrationLimit());
        hashCode = 31 * hashCode + Objects.hashCode(registrationsCount());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(expired());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activation)) {
            return false;
        }
        Activation other = (Activation) obj;
        return Objects.equals(activationId(), other.activationId()) && Objects.equals(description(), other.description())
                && Objects.equals(defaultInstanceName(), other.defaultInstanceName())
                && Objects.equals(iamRole(), other.iamRole()) && Objects.equals(registrationLimit(), other.registrationLimit())
                && Objects.equals(registrationsCount(), other.registrationsCount())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(expired(), other.expired())
                && Objects.equals(createdDate(), other.createdDate());
    }

    @Override
    public String toString() {
        return ToString.builder("Activation").add("ActivationId", activationId()).add("Description", description())
                .add("DefaultInstanceName", defaultInstanceName()).add("IamRole", iamRole())
                .add("RegistrationLimit", registrationLimit()).add("RegistrationsCount", registrationsCount())
                .add("ExpirationDate", expirationDate()).add("Expired", expired()).add("CreatedDate", createdDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationId":
            return Optional.ofNullable(clazz.cast(activationId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultInstanceName":
            return Optional.ofNullable(clazz.cast(defaultInstanceName()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "RegistrationLimit":
            return Optional.ofNullable(clazz.cast(registrationLimit()));
        case "RegistrationsCount":
            return Optional.ofNullable(clazz.cast(registrationsCount()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Expired":
            return Optional.ofNullable(clazz.cast(expired()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Activation> {
        /**
         * <p>
         * The ID created by Systems Manager when you submitted the activation.
         * </p>
         * 
         * @param activationId
         *        The ID created by Systems Manager when you submitted the activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);

        /**
         * <p>
         * A user defined description of the activation.
         * </p>
         * 
         * @param description
         *        A user defined description of the activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the managed instance when it is created.
         * </p>
         * 
         * @param defaultInstanceName
         *        A name for the managed instance when it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceName(String defaultInstanceName);

        /**
         * <p>
         * The Amazon Identity and Access Management (IAM) role to assign to the managed instance.
         * </p>
         * 
         * @param iamRole
         *        The Amazon Identity and Access Management (IAM) role to assign to the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * The maximum number of managed instances that can be registered using this activation.
         * </p>
         * 
         * @param registrationLimit
         *        The maximum number of managed instances that can be registered using this activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationLimit(Integer registrationLimit);

        /**
         * <p>
         * The number of managed instances already registered with this activation.
         * </p>
         * 
         * @param registrationsCount
         *        The number of managed instances already registered with this activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationsCount(Integer registrationsCount);

        /**
         * <p>
         * The date when this activation can no longer be used to register managed instances.
         * </p>
         * 
         * @param expirationDate
         *        The date when this activation can no longer be used to register managed instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * Whether or not the activation is expired.
         * </p>
         * 
         * @param expired
         *        Whether or not the activation is expired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expired(Boolean expired);

        /**
         * <p>
         * The date the activation was created.
         * </p>
         * 
         * @param createdDate
         *        The date the activation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl implements Builder {
        private String activationId;

        private String description;

        private String defaultInstanceName;

        private String iamRole;

        private Integer registrationLimit;

        private Integer registrationsCount;

        private Instant expirationDate;

        private Boolean expired;

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Activation model) {
            activationId(model.activationId);
            description(model.description);
            defaultInstanceName(model.defaultInstanceName);
            iamRole(model.iamRole);
            registrationLimit(model.registrationLimit);
            registrationsCount(model.registrationsCount);
            expirationDate(model.expirationDate);
            expired(model.expired);
            createdDate(model.createdDate);
        }

        public final String getActivationId() {
            return activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultInstanceName() {
            return defaultInstanceName;
        }

        @Override
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Integer getRegistrationLimit() {
            return registrationLimit;
        }

        @Override
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        public final Integer getRegistrationsCount() {
            return registrationsCount;
        }

        @Override
        public final Builder registrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
            return this;
        }

        public final void setRegistrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final Boolean getExpired() {
            return expired;
        }

        @Override
        public final Builder expired(Boolean expired) {
            this.expired = expired;
            return this;
        }

        public final void setExpired(Boolean expired) {
            this.expired = expired;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public Activation build() {
            return new Activation(this);
        }
    }
}
