/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMaintenanceWindowResponse extends SsmResponse implements
        ToCopyableBuilder<DeleteMaintenanceWindowResponse.Builder, DeleteMaintenanceWindowResponse> {
    private final String windowId;

    private DeleteMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
    }

    /**
     * <p>
     * The ID of the deleted Maintenance Window.
     * </p>
     * 
     * @return The ID of the deleted Maintenance Window.
     */
    public String windowId() {
        return windowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMaintenanceWindowResponse)) {
            return false;
        }
        DeleteMaintenanceWindowResponse other = (DeleteMaintenanceWindowResponse) obj;
        return Objects.equals(windowId(), other.windowId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteMaintenanceWindowResponse").add("WindowId", windowId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmResponse.Builder, CopyableBuilder<Builder, DeleteMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the deleted Maintenance Window.
         * </p>
         * 
         * @param windowId
         *        The ID of the deleted Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String windowId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMaintenanceWindowResponse model) {
            super(model);
            windowId(model.windowId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public DeleteMaintenanceWindowResponse build() {
            return new DeleteMaintenanceWindowResponse(this);
        }
    }
}
