/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceWindowExecutionTaskInvocationsResponse extends SsmResponse
        implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionTaskInvocationsResponse.Builder, DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {
    private final List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTaskInvocationsResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionTaskInvocationIdentities = builder.windowExecutionTaskInvocationIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the task invocation results per invocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the task invocation results per invocation.
     */
    public List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities() {
        return windowExecutionTaskInvocationIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionTaskInvocationIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTaskInvocationsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTaskInvocationsResponse other = (DescribeMaintenanceWindowExecutionTaskInvocationsResponse) obj;
        return Objects.equals(windowExecutionTaskInvocationIdentities(), other.windowExecutionTaskInvocationIdentities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMaintenanceWindowExecutionTaskInvocationsResponse")
                .add("WindowExecutionTaskInvocationIdentities", windowExecutionTaskInvocationIdentities())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionTaskInvocationIdentities":
            return Optional.ofNullable(clazz.cast(windowExecutionTaskInvocationIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmResponse.Builder,
            CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {
        /**
         * <p>
         * Information about the task invocation results per invocation.
         * </p>
         * 
         * @param windowExecutionTaskInvocationIdentities
         *        Information about the task invocation results per invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities);

        /**
         * <p>
         * Information about the task invocation results per invocation.
         * </p>
         * 
         * @param windowExecutionTaskInvocationIdentities
         *        Information about the task invocation results per invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskInvocationIdentities(
                MaintenanceWindowExecutionTaskInvocationIdentity... windowExecutionTaskInvocationIdentities);

        /**
         * <p>
         * Information about the task invocation results per invocation.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <MaintenanceWindowExecutionTaskInvocationIdentity>.Builder} avoiding the need to create one manually via
         * {@link List<MaintenanceWindowExecutionTaskInvocationIdentity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <MaintenanceWindowExecutionTaskInvocationIdentity>.Builder#build()} is called immediately and its result is
         * passed to {@link
         * #windowExecutionTaskInvocationIdentities(List<MaintenanceWindowExecutionTaskInvocationIdentity>)}.
         * 
         * @param windowExecutionTaskInvocationIdentities
         *        a consumer that will call methods on {@link List
         *        <MaintenanceWindowExecutionTaskInvocationIdentity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowExecutionTaskInvocationIdentities(List<MaintenanceWindowExecutionTaskInvocationIdentity>)
         */
        Builder windowExecutionTaskInvocationIdentities(
                Consumer<MaintenanceWindowExecutionTaskInvocationIdentity.Builder>... windowExecutionTaskInvocationIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTaskInvocationsResponse model) {
            super(model);
            windowExecutionTaskInvocationIdentities(model.windowExecutionTaskInvocationIdentities);
            nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecutionTaskInvocationIdentity.Builder> getWindowExecutionTaskInvocationIdentities() {
            return windowExecutionTaskInvocationIdentities != null ? windowExecutionTaskInvocationIdentities.stream()
                    .map(MaintenanceWindowExecutionTaskInvocationIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities = MaintenanceWindowExecutionTaskInvocationIdentityListCopier
                    .copy(windowExecutionTaskInvocationIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskInvocationIdentities(
                MaintenanceWindowExecutionTaskInvocationIdentity... windowExecutionTaskInvocationIdentities) {
            windowExecutionTaskInvocationIdentities(Arrays.asList(windowExecutionTaskInvocationIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskInvocationIdentities(
                Consumer<MaintenanceWindowExecutionTaskInvocationIdentity.Builder>... windowExecutionTaskInvocationIdentities) {
            windowExecutionTaskInvocationIdentities(Stream.of(windowExecutionTaskInvocationIdentities)
                    .map(c -> MaintenanceWindowExecutionTaskInvocationIdentity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWindowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity.BuilderImpl> windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities = MaintenanceWindowExecutionTaskInvocationIdentityListCopier
                    .copyFromBuilder(windowExecutionTaskInvocationIdentities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTaskInvocationsResponse build() {
            return new DescribeMaintenanceWindowExecutionTaskInvocationsResponse(this);
        }
    }
}
