/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inventory item size has exceeded the size limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemSizeLimitExceededException extends SsmException implements
        ToCopyableBuilder<ItemSizeLimitExceededException.Builder, ItemSizeLimitExceededException> {
    private final String typeName;

    private ItemSizeLimitExceededException(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the TypeName property for this object.
     * 
     * @return The value of the TypeName property for this object.
     */
    public String typeName() {
        return typeName;
    }

    public interface Builder extends CopyableBuilder<Builder, ItemSizeLimitExceededException>, SsmException.Builder {
        /**
         * Sets the value of the TypeName property for this object.
         *
         * @param typeName
         *        The new value for the TypeName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SsmException.BuilderImpl implements Builder {
        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemSizeLimitExceededException model) {
            super(model);
            typeName(model.typeName);
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @JsonProperty("TypeName")
        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ItemSizeLimitExceededException build() {
            return new ItemSizeLimitExceededException(this);
        }
    }
}
