/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowRunCommandParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for a RUN_COMMAND task type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindowRunCommandParameters implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowRunCommandParameters.Builder, MaintenanceWindowRunCommandParameters> {
    private final String comment;

    private final String documentHash;

    private final String documentHashType;

    private final NotificationConfig notificationConfig;

    private final String outputS3BucketName;

    private final String outputS3KeyPrefix;

    private final Map<String, List<String>> parameters;

    private final String serviceRoleArn;

    private final Integer timeoutSeconds;

    private MaintenanceWindowRunCommandParameters(BuilderImpl builder) {
        this.comment = builder.comment;
        this.documentHash = builder.documentHash;
        this.documentHashType = builder.documentHashType;
        this.notificationConfig = builder.notificationConfig;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.parameters = builder.parameters;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    /**
     * <p>
     * Information about the command(s) to execute.
     * </p>
     * 
     * @return Information about the command(s) to execute.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
     * </p>
     * 
     * @return The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been
     *         deprecated.
     */
    public String documentHash() {
        return documentHash;
    }

    /**
     * <p>
     * SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentHashType}
     * will return {@link DocumentHashType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentHashTypeAsString}.
     * </p>
     * 
     * @return SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
     * @see DocumentHashType
     */
    public DocumentHashType documentHashType() {
        return DocumentHashType.fromValue(documentHashType);
    }

    /**
     * <p>
     * SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentHashType}
     * will return {@link DocumentHashType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentHashTypeAsString}.
     * </p>
     * 
     * @return SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
     * @see DocumentHashType
     */
    public String documentHashTypeAsString() {
        return documentHashType;
    }

    /**
     * <p>
     * Configurations for sending notifications about command status changes on a per-instance basis.
     * </p>
     * 
     * @return Configurations for sending notifications about command status changes on a per-instance basis.
     */
    public NotificationConfig notificationConfig() {
        return notificationConfig;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket.
     */
    public String outputS3BucketName() {
        return outputS3BucketName;
    }

    /**
     * <p>
     * The Amazon S3 bucket subfolder.
     * </p>
     * 
     * @return The Amazon S3 bucket subfolder.
     */
    public String outputS3KeyPrefix() {
        return outputS3KeyPrefix;
    }

    /**
     * <p>
     * The parameters for the RUN_COMMAND task execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameters for the RUN_COMMAND task execution.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The IAM service role to assume during task execution.
     * </p>
     * 
     * @return The IAM service role to assume during task execution.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * If this time is reached and the command has not already started executing, it doesn not execute.
     * </p>
     * 
     * @return If this time is reached and the command has not already started executing, it doesn not execute.
     */
    public Integer timeoutSeconds() {
        return timeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(documentHash());
        hashCode = 31 * hashCode + Objects.hashCode(documentHashTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowRunCommandParameters)) {
            return false;
        }
        MaintenanceWindowRunCommandParameters other = (MaintenanceWindowRunCommandParameters) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(documentHash(), other.documentHash())
                && Objects.equals(documentHashTypeAsString(), other.documentHashTypeAsString())
                && Objects.equals(notificationConfig(), other.notificationConfig())
                && Objects.equals(outputS3BucketName(), other.outputS3BucketName())
                && Objects.equals(outputS3KeyPrefix(), other.outputS3KeyPrefix())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(timeoutSeconds(), other.timeoutSeconds());
    }

    @Override
    public String toString() {
        return ToString.builder("MaintenanceWindowRunCommandParameters").add("Comment", comment())
                .add("DocumentHash", documentHash()).add("DocumentHashType", documentHashTypeAsString())
                .add("NotificationConfig", notificationConfig()).add("OutputS3BucketName", outputS3BucketName())
                .add("OutputS3KeyPrefix", outputS3KeyPrefix()).add("Parameters", parameters())
                .add("ServiceRoleArn", serviceRoleArn()).add("TimeoutSeconds", timeoutSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "DocumentHash":
            return Optional.ofNullable(clazz.cast(documentHash()));
        case "DocumentHashType":
            return Optional.ofNullable(clazz.cast(documentHashTypeAsString()));
        case "NotificationConfig":
            return Optional.ofNullable(clazz.cast(notificationConfig()));
        case "OutputS3BucketName":
            return Optional.ofNullable(clazz.cast(outputS3BucketName()));
        case "OutputS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(outputS3KeyPrefix()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "TimeoutSeconds":
            return Optional.ofNullable(clazz.cast(timeoutSeconds()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowRunCommandParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowRunCommandParameters> {
        /**
         * <p>
         * Information about the command(s) to execute.
         * </p>
         * 
         * @param comment
         *        Information about the command(s) to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been
         * deprecated.
         * </p>
         * 
         * @param documentHash
         *        The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been
         *        deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentHash(String documentHash);

        /**
         * <p>
         * SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
         * </p>
         * 
         * @param documentHashType
         *        SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
         * @see DocumentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentHashType
         */
        Builder documentHashType(String documentHashType);

        /**
         * <p>
         * SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
         * </p>
         * 
         * @param documentHashType
         *        SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
         * @see DocumentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentHashType
         */
        Builder documentHashType(DocumentHashType documentHashType);

        /**
         * <p>
         * Configurations for sending notifications about command status changes on a per-instance basis.
         * </p>
         * 
         * @param notificationConfig
         *        Configurations for sending notifications about command status changes on a per-instance basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfig(NotificationConfig notificationConfig);

        /**
         * <p>
         * Configurations for sending notifications about command status changes on a per-instance basis.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationConfig.Builder} avoiding the need to
         * create one manually via {@link NotificationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #notificationConfig(NotificationConfig)}.
         * 
         * @param notificationConfig
         *        a consumer that will call methods on {@link NotificationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfig(NotificationConfig)
         */
        default Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return notificationConfig(NotificationConfig.builder().applyMutation(notificationConfig).build());
        }

        /**
         * <p>
         * The name of the Amazon S3 bucket.
         * </p>
         * 
         * @param outputS3BucketName
         *        The name of the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3BucketName(String outputS3BucketName);

        /**
         * <p>
         * The Amazon S3 bucket subfolder.
         * </p>
         * 
         * @param outputS3KeyPrefix
         *        The Amazon S3 bucket subfolder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3KeyPrefix(String outputS3KeyPrefix);

        /**
         * <p>
         * The parameters for the RUN_COMMAND task execution.
         * </p>
         * 
         * @param parameters
         *        The parameters for the RUN_COMMAND task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The IAM service role to assume during task execution.
         * </p>
         * 
         * @param serviceRoleArn
         *        The IAM service role to assume during task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * If this time is reached and the command has not already started executing, it doesn not execute.
         * </p>
         * 
         * @param timeoutSeconds
         *        If this time is reached and the command has not already started executing, it doesn not execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSeconds(Integer timeoutSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private String documentHash;

        private String documentHashType;

        private NotificationConfig notificationConfig;

        private String outputS3BucketName;

        private String outputS3KeyPrefix;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String serviceRoleArn;

        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowRunCommandParameters model) {
            comment(model.comment);
            documentHash(model.documentHash);
            documentHashType(model.documentHashType);
            notificationConfig(model.notificationConfig);
            outputS3BucketName(model.outputS3BucketName);
            outputS3KeyPrefix(model.outputS3KeyPrefix);
            parameters(model.parameters);
            serviceRoleArn(model.serviceRoleArn);
            timeoutSeconds(model.timeoutSeconds);
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDocumentHash() {
            return documentHash;
        }

        @Override
        public final Builder documentHash(String documentHash) {
            this.documentHash = documentHash;
            return this;
        }

        public final void setDocumentHash(String documentHash) {
            this.documentHash = documentHash;
        }

        public final String getDocumentHashType() {
            return documentHashType;
        }

        @Override
        public final Builder documentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
            return this;
        }

        @Override
        public final Builder documentHashType(DocumentHashType documentHashType) {
            this.documentHashType(documentHashType.toString());
            return this;
        }

        public final void setDocumentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return notificationConfig != null ? notificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        public final String getOutputS3BucketName() {
            return outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Integer getTimeoutSeconds() {
            return timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public MaintenanceWindowRunCommandParameters build() {
            return new MaintenanceWindowRunCommandParameters(this);
        }
    }
}
