/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssociationStatusRequest extends SsmRequest implements
        ToCopyableBuilder<UpdateAssociationStatusRequest.Builder, UpdateAssociationStatusRequest> {
    private final String name;

    private final String instanceId;

    private final AssociationStatus associationStatus;

    private UpdateAssociationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.associationStatus = builder.associationStatus;
    }

    /**
     * <p>
     * The name of the Systems Manager document.
     * </p>
     * 
     * @return The name of the Systems Manager document.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The association status.
     * </p>
     * 
     * @return The association status.
     */
    public AssociationStatus associationStatus() {
        return associationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssociationStatusRequest)) {
            return false;
        }
        UpdateAssociationStatusRequest other = (UpdateAssociationStatusRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(associationStatus(), other.associationStatus());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateAssociationStatusRequest").add("Name", name()).add("InstanceId", instanceId())
                .add("AssociationStatus", associationStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AssociationStatus":
            return Optional.ofNullable(clazz.cast(associationStatus()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmRequest.Builder, CopyableBuilder<Builder, UpdateAssociationStatusRequest> {
        /**
         * <p>
         * The name of the Systems Manager document.
         * </p>
         * 
         * @param name
         *        The name of the Systems Manager document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The association status.
         * </p>
         * 
         * @param associationStatus
         *        The association status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationStatus(AssociationStatus associationStatus);

        /**
         * <p>
         * The association status.
         * </p>
         * This is a convenience that creates an instance of the {@link AssociationStatus.Builder} avoiding the need to
         * create one manually via {@link AssociationStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssociationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #associationStatus(AssociationStatus)}.
         * 
         * @param associationStatus
         *        a consumer that will call methods on {@link AssociationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationStatus(AssociationStatus)
         */
        default Builder associationStatus(Consumer<AssociationStatus.Builder> associationStatus) {
            return associationStatus(AssociationStatus.builder().applyMutation(associationStatus).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String name;

        private String instanceId;

        private AssociationStatus associationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssociationStatusRequest model) {
            super(model);
            name(model.name);
            instanceId(model.instanceId);
            associationStatus(model.associationStatus);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final AssociationStatus.Builder getAssociationStatus() {
            return associationStatus != null ? associationStatus.toBuilder() : null;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final void setAssociationStatus(AssociationStatus.BuilderImpl associationStatus) {
            this.associationStatus = associationStatus != null ? associationStatus.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssociationStatusRequest build() {
            return new UpdateAssociationStatusRequest(this);
        }
    }
}
