/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DocumentDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DocumentDescriptionMarshaller {
    private static final MarshallingInfo<String> SHA1_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sha1").isBinary(false).build();

    private static final MarshallingInfo<String> HASH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hash").isBinary(false).build();

    private static final MarshallingInfo<String> HASHTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HashType").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();

    private static final MarshallingInfo<List> PLATFORMTYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformTypes").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").isBinary(false).build();

    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").isBinary(false).build();

    private static final MarshallingInfo<String> LATESTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersion").isBinary(false).build();

    private static final MarshallingInfo<String> DEFAULTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultVersion").isBinary(false).build();

    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();

    private static final DocumentDescriptionMarshaller INSTANCE = new DocumentDescriptionMarshaller();

    private DocumentDescriptionMarshaller() {
    }

    public static DocumentDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DocumentDescription documentDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(documentDescription, "documentDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(documentDescription.sha1(), SHA1_BINDING);
            protocolMarshaller.marshall(documentDescription.hash(), HASH_BINDING);
            protocolMarshaller.marshall(documentDescription.hashTypeAsString(), HASHTYPE_BINDING);
            protocolMarshaller.marshall(documentDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall(documentDescription.owner(), OWNER_BINDING);
            protocolMarshaller.marshall(documentDescription.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall(documentDescription.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(documentDescription.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(documentDescription.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(documentDescription.platformTypesAsStrings(), PLATFORMTYPES_BINDING);
            protocolMarshaller.marshall(documentDescription.documentTypeAsString(), DOCUMENTTYPE_BINDING);
            protocolMarshaller.marshall(documentDescription.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.latestVersion(), LATESTVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.defaultVersion(), DEFAULTVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.tags(), TAGS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
