/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MaintenanceWindowExecutionTaskInvocationIdentity} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MaintenanceWindowExecutionTaskInvocationIdentityMarshaller {
    private static final MarshallingInfo<String> WINDOWEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowExecutionId").isBinary(false).build();

    private static final MarshallingInfo<String> TASKEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskExecutionId").isBinary(false).build();

    private static final MarshallingInfo<String> INVOCATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvocationId").isBinary(false).build();

    private static final MarshallingInfo<String> EXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionId").isBinary(false).build();

    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskType").isBinary(false).build();

    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();

    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").isBinary(false).build();

    private static final MarshallingInfo<String> WINDOWTARGETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTargetId").isBinary(false).build();

    private static final MaintenanceWindowExecutionTaskInvocationIdentityMarshaller INSTANCE = new MaintenanceWindowExecutionTaskInvocationIdentityMarshaller();

    private MaintenanceWindowExecutionTaskInvocationIdentityMarshaller() {
    }

    public static MaintenanceWindowExecutionTaskInvocationIdentityMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MaintenanceWindowExecutionTaskInvocationIdentity maintenanceWindowExecutionTaskInvocationIdentity,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(maintenanceWindowExecutionTaskInvocationIdentity,
                "maintenanceWindowExecutionTaskInvocationIdentity");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.windowExecutionId(),
                    WINDOWEXECUTIONID_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.taskExecutionId(),
                    TASKEXECUTIONID_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.invocationId(), INVOCATIONID_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.executionId(), EXECUTIONID_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.taskTypeAsString(), TASKTYPE_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecutionTaskInvocationIdentity.ownerInformation(),
                    OWNERINFORMATION_BINDING);
            protocolMarshaller
                    .marshall(maintenanceWindowExecutionTaskInvocationIdentity.windowTargetId(), WINDOWTARGETID_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
