/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link StartAutomationExecutionRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class StartAutomationExecutionRequestModelMarshaller {
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();

    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").isBinary(false).build();

    private static final StartAutomationExecutionRequestModelMarshaller INSTANCE = new StartAutomationExecutionRequestModelMarshaller();

    private StartAutomationExecutionRequestModelMarshaller() {
    }

    public static StartAutomationExecutionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(StartAutomationExecutionRequest startAutomationExecutionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(startAutomationExecutionRequest, "startAutomationExecutionRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(startAutomationExecutionRequest.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall(startAutomationExecutionRequest.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(startAutomationExecutionRequest.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(startAutomationExecutionRequest.clientToken(), CLIENTTOKEN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
