/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowExecutionsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowExecutionsResponse> {
    private final List<MaintenanceWindowExecution> windowExecutions;
    private final String nextToken;

    private DescribeMaintenanceWindowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutions = builder.windowExecutions;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowExecution> windowExecutions() {
        return this.windowExecutions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionsResponse other = (DescribeMaintenanceWindowExecutionsResponse)((Object)obj);
        return Objects.equals(this.windowExecutions(), other.windowExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowExecutionsResponse").add("WindowExecutions", this.windowExecutions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutions": {
                return Optional.ofNullable(clazz.cast(this.windowExecutions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowExecution> windowExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionsResponse model) {
            super(model);
            this.windowExecutions(model.windowExecutions);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecution.Builder> getWindowExecutions() {
            return this.windowExecutions != null ? (Collection)this.windowExecutions.stream().map(MaintenanceWindowExecution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowExecutions(Collection<MaintenanceWindowExecution> windowExecutions) {
            this.windowExecutions = MaintenanceWindowExecutionListCopier.copy(windowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutions(MaintenanceWindowExecution ... windowExecutions) {
            this.windowExecutions(Arrays.asList(windowExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutions(Consumer<MaintenanceWindowExecution.Builder> ... windowExecutions) {
            this.windowExecutions(Stream.of(windowExecutions).map(c -> (MaintenanceWindowExecution)((MaintenanceWindowExecution.Builder)MaintenanceWindowExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWindowExecutions(Collection<MaintenanceWindowExecution.BuilderImpl> windowExecutions) {
            this.windowExecutions = MaintenanceWindowExecutionListCopier.copyFromBuilder(windowExecutions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowExecutionsResponse build() {
            return new DescribeMaintenanceWindowExecutionsResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionsResponse> {
        public Builder windowExecutions(Collection<MaintenanceWindowExecution> var1);

        public Builder windowExecutions(MaintenanceWindowExecution ... var1);

        public Builder windowExecutions(Consumer<MaintenanceWindowExecution.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

