/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryResultEntity;
import software.amazon.awssdk.services.ssm.model.InventoryResultEntityListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInventoryResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetInventoryResponse> {
    private final List<InventoryResultEntity> entities;
    private final String nextToken;

    private GetInventoryResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.nextToken = builder.nextToken;
    }

    public List<InventoryResultEntity> entities() {
        return this.entities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryResponse)) {
            return false;
        }
        GetInventoryResponse other = (GetInventoryResponse)((Object)obj);
        return Objects.equals(this.entities(), other.entities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetInventoryResponse").add("Entities", this.entities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<InventoryResultEntity> entities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryResponse model) {
            super(model);
            this.entities(model.entities);
            this.nextToken(model.nextToken);
        }

        public final Collection<InventoryResultEntity.Builder> getEntities() {
            return this.entities != null ? (Collection)this.entities.stream().map(InventoryResultEntity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<InventoryResultEntity> entities) {
            this.entities = InventoryResultEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(InventoryResultEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<InventoryResultEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (InventoryResultEntity)((InventoryResultEntity.Builder)InventoryResultEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<InventoryResultEntity.BuilderImpl> entities) {
            this.entities = InventoryResultEntityListCopier.copyFromBuilder(entities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInventoryResponse build() {
            return new GetInventoryResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, GetInventoryResponse> {
        public Builder entities(Collection<InventoryResultEntity> var1);

        public Builder entities(InventoryResultEntity ... var1);

        public Builder entities(Consumer<InventoryResultEntity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

