/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem;
import software.amazon.awssdk.services.ssm.model.ComplianceSummaryItemListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComplianceSummariesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListComplianceSummariesResponse> {
    private final List<ComplianceSummaryItem> complianceSummaryItems;
    private final String nextToken;

    private ListComplianceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.complianceSummaryItems = builder.complianceSummaryItems;
        this.nextToken = builder.nextToken;
    }

    public List<ComplianceSummaryItem> complianceSummaryItems() {
        return this.complianceSummaryItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSummaryItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceSummariesResponse)) {
            return false;
        }
        ListComplianceSummariesResponse other = (ListComplianceSummariesResponse)((Object)obj);
        return Objects.equals(this.complianceSummaryItems(), other.complianceSummaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListComplianceSummariesResponse").add("ComplianceSummaryItems", this.complianceSummaryItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceSummaryItems": {
                return Optional.ofNullable(clazz.cast(this.complianceSummaryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<ComplianceSummaryItem> complianceSummaryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceSummariesResponse model) {
            super(model);
            this.complianceSummaryItems(model.complianceSummaryItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ComplianceSummaryItem.Builder> getComplianceSummaryItems() {
            return this.complianceSummaryItems != null ? (Collection)this.complianceSummaryItems.stream().map(ComplianceSummaryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceSummaryItems(Collection<ComplianceSummaryItem> complianceSummaryItems) {
            this.complianceSummaryItems = ComplianceSummaryItemListCopier.copy(complianceSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummaryItems(ComplianceSummaryItem ... complianceSummaryItems) {
            this.complianceSummaryItems(Arrays.asList(complianceSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummaryItems(Consumer<ComplianceSummaryItem.Builder> ... complianceSummaryItems) {
            this.complianceSummaryItems(Stream.of(complianceSummaryItems).map(c -> (ComplianceSummaryItem)((ComplianceSummaryItem.Builder)ComplianceSummaryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceSummaryItems(Collection<ComplianceSummaryItem.BuilderImpl> complianceSummaryItems) {
            this.complianceSummaryItems = ComplianceSummaryItemListCopier.copyFromBuilder(complianceSummaryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComplianceSummariesResponse build() {
            return new ListComplianceSummariesResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, ListComplianceSummariesResponse> {
        public Builder complianceSummaryItems(Collection<ComplianceSummaryItem> var1);

        public Builder complianceSummaryItems(ComplianceSummaryItem ... var1);

        public Builder complianceSummaryItems(Consumer<ComplianceSummaryItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

