/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryItemEntryListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInventoryEntriesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListInventoryEntriesResponse> {
    private final String typeName;
    private final String instanceId;
    private final String schemaVersion;
    private final String captureTime;
    private final List<Map<String, String>> entries;
    private final String nextToken;

    private ListInventoryEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.instanceId = builder.instanceId;
        this.schemaVersion = builder.schemaVersion;
        this.captureTime = builder.captureTime;
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    public String typeName() {
        return this.typeName;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public String captureTime() {
        return this.captureTime;
    }

    public List<Map<String, String>> entries() {
        return this.entries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.entries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInventoryEntriesResponse)) {
            return false;
        }
        ListInventoryEntriesResponse other = (ListInventoryEntriesResponse)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.captureTime(), other.captureTime()) && Objects.equals(this.entries(), other.entries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInventoryEntriesResponse").add("TypeName", (Object)this.typeName()).add("InstanceId", (Object)this.instanceId()).add("SchemaVersion", (Object)this.schemaVersion()).add("CaptureTime", (Object)this.captureTime()).add("Entries", this.entries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "CaptureTime": {
                return Optional.ofNullable(clazz.cast(this.captureTime()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String typeName;
        private String instanceId;
        private String schemaVersion;
        private String captureTime;
        private List<Map<String, String>> entries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInventoryEntriesResponse model) {
            super(model);
            this.typeName(model.typeName);
            this.instanceId(model.instanceId);
            this.schemaVersion(model.schemaVersion);
            this.captureTime(model.captureTime);
            this.entries(model.entries);
            this.nextToken(model.nextToken);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getCaptureTime() {
            return this.captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        public final Collection<Map<String, String>> getEntries() {
            return this.entries;
        }

        @Override
        public final Builder entries(Collection<Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Map<String, String> ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInventoryEntriesResponse build() {
            return new ListInventoryEntriesResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, ListInventoryEntriesResponse> {
        public Builder typeName(String var1);

        public Builder instanceId(String var1);

        public Builder schemaVersion(String var1);

        public Builder captureTime(String var1);

        public Builder entries(Collection<Map<String, String>> var1);

        public Builder entries(Map<String, String> ... var1);

        public Builder nextToken(String var1);
    }
}

