/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InstanceAssociation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceAssociationMarshaller {
    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationVersion").isBinary(false).build();
    private static final InstanceAssociationMarshaller INSTANCE = new InstanceAssociationMarshaller();

    private InstanceAssociationMarshaller() {
    }

    public static InstanceAssociationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceAssociation instanceAssociation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceAssociation, (String)"instanceAssociation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceAssociation.associationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociation.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociation.content(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)instanceAssociation.associationVersion(), ASSOCIATIONVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

