/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MaintenanceWindowIdentityMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").isBinary(false).build();
    private static final MarshallingInfo<Integer> CUTOFF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cutoff").isBinary(false).build();
    private static final MaintenanceWindowIdentityMarshaller INSTANCE = new MaintenanceWindowIdentityMarshaller();

    private MaintenanceWindowIdentityMarshaller() {
    }

    public static MaintenanceWindowIdentityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MaintenanceWindowIdentity maintenanceWindowIdentity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)maintenanceWindowIdentity, (String)"maintenanceWindowIdentity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)maintenanceWindowIdentity.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowIdentity.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowIdentity.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowIdentity.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowIdentity.duration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowIdentity.cutoff(), CUTOFF_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

