/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssociationBatchRequest extends SsmRequest implements
        ToCopyableBuilder<CreateAssociationBatchRequest.Builder, CreateAssociationBatchRequest> {
    private final List<CreateAssociationBatchRequestEntry> entries;

    private CreateAssociationBatchRequest(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
    }

    /**
     * <p>
     * One or more associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more associations.
     */
    public List<CreateAssociationBatchRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchRequest)) {
            return false;
        }
        CreateAssociationBatchRequest other = (CreateAssociationBatchRequest) obj;
        return Objects.equals(entries(), other.entries());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateAssociationBatchRequest").add("Entries", entries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmRequest.Builder, CopyableBuilder<Builder, CreateAssociationBatchRequest> {
        /**
         * <p>
         * One or more associations.
         * </p>
         * 
         * @param entries
         *        One or more associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<CreateAssociationBatchRequestEntry> entries);

        /**
         * <p>
         * One or more associations.
         * </p>
         * 
         * @param entries
         *        One or more associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(CreateAssociationBatchRequestEntry... entries);

        /**
         * <p>
         * One or more associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <CreateAssociationBatchRequestEntry>.Builder} avoiding the need to create one manually via {@link List
         * <CreateAssociationBatchRequestEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateAssociationBatchRequestEntry>.Builder#build()} is
         * called immediately and its result is passed to {@link #entries(List<CreateAssociationBatchRequestEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<CreateAssociationBatchRequestEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<CreateAssociationBatchRequestEntry>)
         */
        Builder entries(Consumer<CreateAssociationBatchRequestEntry.Builder>... entries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<CreateAssociationBatchRequestEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchRequest model) {
            super(model);
            entries(model.entries);
        }

        public final Collection<CreateAssociationBatchRequestEntry.Builder> getEntries() {
            return entries != null ? entries.stream().map(CreateAssociationBatchRequestEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<CreateAssociationBatchRequestEntry> entries) {
            this.entries = CreateAssociationBatchRequestEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(CreateAssociationBatchRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<CreateAssociationBatchRequestEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> CreateAssociationBatchRequestEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<CreateAssociationBatchRequestEntry.BuilderImpl> entries) {
            this.entries = CreateAssociationBatchRequestEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssociationBatchRequest build() {
            return new CreateAssociationBatchRequest(this);
        }
    }
}
