/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CommandInvocation;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CommandInvocation} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CommandInvocationMarshaller {
    private static final MarshallingInfo<String> COMMANDID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandId").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceName").isBinary(false).build();

    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").isBinary(false).build();

    private static final MarshallingInfo<Instant> REQUESTEDDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedDateTime").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").isBinary(false).build();

    private static final MarshallingInfo<String> TRACEOUTPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TraceOutput").isBinary(false).build();

    private static final MarshallingInfo<String> STANDARDOUTPUTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardOutputUrl").isBinary(false).build();

    private static final MarshallingInfo<String> STANDARDERRORURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardErrorUrl").isBinary(false).build();

    private static final MarshallingInfo<List> COMMANDPLUGINS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandPlugins").isBinary(false).build();

    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NotificationConfig").isBinary(false).build();

    private static final CommandInvocationMarshaller INSTANCE = new CommandInvocationMarshaller();

    private CommandInvocationMarshaller() {
    }

    public static CommandInvocationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CommandInvocation commandInvocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(commandInvocation, "commandInvocation");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(commandInvocation.commandId(), COMMANDID_BINDING);
            protocolMarshaller.marshall(commandInvocation.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(commandInvocation.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall(commandInvocation.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall(commandInvocation.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall(commandInvocation.requestedDateTime(), REQUESTEDDATETIME_BINDING);
            protocolMarshaller.marshall(commandInvocation.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(commandInvocation.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall(commandInvocation.traceOutput(), TRACEOUTPUT_BINDING);
            protocolMarshaller.marshall(commandInvocation.standardOutputUrl(), STANDARDOUTPUTURL_BINDING);
            protocolMarshaller.marshall(commandInvocation.standardErrorUrl(), STANDARDERRORURL_BINDING);
            protocolMarshaller.marshall(commandInvocation.commandPlugins(), COMMANDPLUGINS_BINDING);
            protocolMarshaller.marshall(commandInvocation.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall(commandInvocation.notificationConfig(), NOTIFICATIONCONFIG_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
