/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CompliantSummary;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CompliantSummary} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CompliantSummaryMarshaller {
    private static final MarshallingInfo<Integer> COMPLIANTCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompliantCount").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SEVERITYSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SeveritySummary").isBinary(false).build();

    private static final CompliantSummaryMarshaller INSTANCE = new CompliantSummaryMarshaller();

    private CompliantSummaryMarshaller() {
    }

    public static CompliantSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CompliantSummary compliantSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(compliantSummary, "compliantSummary");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(compliantSummary.compliantCount(), COMPLIANTCOUNT_BINDING);
            protocolMarshaller.marshall(compliantSummary.severitySummary(), SEVERITYSUMMARY_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
