/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetMaintenanceWindowExecutionTaskInvocationRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetMaintenanceWindowExecutionTaskInvocationRequestModelMarshaller {
    private static final MarshallingInfo<String> WINDOWEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowExecutionId").isBinary(false).build();

    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskId").isBinary(false).build();

    private static final MarshallingInfo<String> INVOCATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvocationId").isBinary(false).build();

    private static final GetMaintenanceWindowExecutionTaskInvocationRequestModelMarshaller INSTANCE = new GetMaintenanceWindowExecutionTaskInvocationRequestModelMarshaller();

    private GetMaintenanceWindowExecutionTaskInvocationRequestModelMarshaller() {
    }

    public static GetMaintenanceWindowExecutionTaskInvocationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetMaintenanceWindowExecutionTaskInvocationRequest getMaintenanceWindowExecutionTaskInvocationRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getMaintenanceWindowExecutionTaskInvocationRequest,
                "getMaintenanceWindowExecutionTaskInvocationRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getMaintenanceWindowExecutionTaskInvocationRequest.windowExecutionId(),
                    WINDOWEXECUTIONID_BINDING);
            protocolMarshaller.marshall(getMaintenanceWindowExecutionTaskInvocationRequest.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall(getMaintenanceWindowExecutionTaskInvocationRequest.invocationId(), INVOCATIONID_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
