/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetMaintenanceWindowTaskResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetMaintenanceWindowTaskResponseUnmarshaller implements
        Unmarshaller<GetMaintenanceWindowTaskResponse, JsonUnmarshallerContext> {

    public GetMaintenanceWindowTaskResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetMaintenanceWindowTaskResponse.Builder getMaintenanceWindowTaskResponseBuilder = GetMaintenanceWindowTaskResponse
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getMaintenanceWindowTaskResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("WindowId", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.windowId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WindowTaskId", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.windowTaskId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Targets", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder
                            .targets(new ListUnmarshaller<Target>(TargetUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("TaskArn", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.taskArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ServiceRoleArn", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.serviceRoleArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("TaskType", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.taskType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TaskParameters", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder
                            .taskParameters(new MapUnmarshaller<String, MaintenanceWindowTaskParameterValueExpression>(context
                                    .getUnmarshaller(String.class), MaintenanceWindowTaskParameterValueExpressionUnmarshaller
                                    .getInstance()).unmarshall(context));
                }
                if (context.testExpression("TaskInvocationParameters", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder
                            .taskInvocationParameters(MaintenanceWindowTaskInvocationParametersUnmarshaller.getInstance()
                                    .unmarshall(context));
                }
                if (context.testExpression("Priority", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.priority(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("MaxConcurrency", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.maxConcurrency(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("MaxErrors", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.maxErrors(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LoggingInfo", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder
                            .loggingInfo(LoggingInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    getMaintenanceWindowTaskResponseBuilder
                            .description(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getMaintenanceWindowTaskResponseBuilder.build();
    }

    private static final GetMaintenanceWindowTaskResponseUnmarshaller INSTANCE = new GetMaintenanceWindowTaskResponseUnmarshaller();

    public static GetMaintenanceWindowTaskResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
