/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ResourceDataSyncItem JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ResourceDataSyncItemUnmarshaller implements Unmarshaller<ResourceDataSyncItem, JsonUnmarshallerContext> {

    public ResourceDataSyncItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceDataSyncItem.Builder resourceDataSyncItemBuilder = ResourceDataSyncItem.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("SyncName", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.syncName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("S3Destination", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.s3Destination(ResourceDataSyncS3DestinationUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("LastSyncTime", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder
                            .lastSyncTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("LastSuccessfulSyncTime", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.lastSuccessfulSyncTime(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("LastStatus", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.lastStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SyncCreatedTime", targetDepth)) {
                    context.nextToken();
                    resourceDataSyncItemBuilder.syncCreatedTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return resourceDataSyncItemBuilder.build();
    }

    private static final ResourceDataSyncItemUnmarshaller INSTANCE = new ResourceDataSyncItemUnmarshaller();

    public static ResourceDataSyncItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}
