/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.services.ssm.model.CommandListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCommandsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListCommandsResponse> {
    private final List<Command> commands;
    private final String nextToken;

    private ListCommandsResponse(BuilderImpl builder) {
        super(builder);
        this.commands = builder.commands;
        this.nextToken = builder.nextToken;
    }

    public List<Command> commands() {
        return this.commands;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commands());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsResponse)) {
            return false;
        }
        ListCommandsResponse other = (ListCommandsResponse)((Object)obj);
        return Objects.equals(this.commands(), other.commands()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCommandsResponse").add("Commands", this.commands()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Commands": {
                return Optional.ofNullable(clazz.cast(this.commands()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<Command> commands = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandsResponse model) {
            super(model);
            this.commands(model.commands);
            this.nextToken(model.nextToken);
        }

        public final Collection<Command.Builder> getCommands() {
            return this.commands != null ? (Collection)this.commands.stream().map(Command::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandListCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command ... commands) {
            this.commands(Arrays.asList(commands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Consumer<Command.Builder> ... commands) {
            this.commands(Stream.of(commands).map(c -> (Command)((Command.Builder)Command.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommands(Collection<Command.BuilderImpl> commands) {
            this.commands = CommandListCopier.copyFromBuilder(commands);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCommandsResponse build() {
            return new ListCommandsResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, ListCommandsResponse> {
        public Builder commands(Collection<Command> var1);

        public Builder commands(Command ... var1);

        public Builder commands(Consumer<Command.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

