/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationVersionInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AssociationVersionInfoMarshaller {
    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationVersion").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEDULEEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduleExpression").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputLocation").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationName").isBinary(false).build();
    private static final AssociationVersionInfoMarshaller INSTANCE = new AssociationVersionInfoMarshaller();

    private AssociationVersionInfoMarshaller() {
    }

    public static AssociationVersionInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociationVersionInfo associationVersionInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)associationVersionInfo, (String)"associationVersionInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)associationVersionInfo.associationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall((Object)associationVersionInfo.associationVersion(), ASSOCIATIONVERSION_BINDING);
            protocolMarshaller.marshall((Object)associationVersionInfo.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)associationVersionInfo.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)associationVersionInfo.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(associationVersionInfo.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)associationVersionInfo.scheduleExpression(), SCHEDULEEXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)associationVersionInfo.outputLocation(), OUTPUTLOCATION_BINDING);
            protocolMarshaller.marshall((Object)associationVersionInfo.associationName(), ASSOCIATIONNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

