/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryResultItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InventoryResultItemMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").isBinary(false).build();
    private static final MarshallingInfo<String> CAPTURETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaptureTime").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentHash").isBinary(false).build();
    private static final MarshallingInfo<List> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").isBinary(false).build();
    private static final InventoryResultItemMarshaller INSTANCE = new InventoryResultItemMarshaller();

    private InventoryResultItemMarshaller() {
    }

    public static InventoryResultItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InventoryResultItem inventoryResultItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inventoryResultItem, (String)"inventoryResultItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inventoryResultItem.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)inventoryResultItem.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)inventoryResultItem.captureTime(), CAPTURETIME_BINDING);
            protocolMarshaller.marshall((Object)inventoryResultItem.contentHash(), CONTENTHASH_BINDING);
            protocolMarshaller.marshall(inventoryResultItem.content(), CONTENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

