/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MaintenanceWindowTaskInvocationParametersMarshaller {
    private static final MarshallingInfo<StructuredPojo> RUNCOMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunCommand").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AUTOMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Automation").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STEPFUNCTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepFunctions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lambda").isBinary(false).build();
    private static final MaintenanceWindowTaskInvocationParametersMarshaller INSTANCE = new MaintenanceWindowTaskInvocationParametersMarshaller();

    private MaintenanceWindowTaskInvocationParametersMarshaller() {
    }

    public static MaintenanceWindowTaskInvocationParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MaintenanceWindowTaskInvocationParameters maintenanceWindowTaskInvocationParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)maintenanceWindowTaskInvocationParameters, (String)"maintenanceWindowTaskInvocationParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)maintenanceWindowTaskInvocationParameters.runCommand(), RUNCOMMAND_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTaskInvocationParameters.automation(), AUTOMATION_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTaskInvocationParameters.stepFunctions(), STEPFUNCTIONS_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTaskInvocationParameters.lambda(), LAMBDA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

