/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;

public class NotificationConfigUnmarshaller
implements Unmarshaller<NotificationConfig, JsonUnmarshallerContext> {
    private static final NotificationConfigUnmarshaller INSTANCE = new NotificationConfigUnmarshaller();

    public NotificationConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        NotificationConfig.Builder notificationConfigBuilder = NotificationConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NotificationArn", targetDepth)) {
                    context.nextToken();
                    notificationConfigBuilder.notificationArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NotificationEvents", targetDepth)) {
                    context.nextToken();
                    notificationConfigBuilder.notificationEventsWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("NotificationType", targetDepth)) {
                    context.nextToken();
                    notificationConfigBuilder.notificationType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (NotificationConfig)notificationConfigBuilder.build();
    }

    public static NotificationConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

