/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter used to match specific automation executions. This is used to limit the scope of Automation execution
 * information returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationExecutionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationExecutionFilter.Builder, AutomationExecutionFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecutionFilter::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AutomationExecutionFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> values;

    private AutomationExecutionFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
    }

    /**
     * <p>
     * The aspect of the Automation execution information that should be limited.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AutomationExecutionFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyAsString}.
     * </p>
     * 
     * @return The aspect of the Automation execution information that should be limited.
     * @see AutomationExecutionFilterKey
     */
    public AutomationExecutionFilterKey key() {
        return AutomationExecutionFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The aspect of the Automation execution information that should be limited.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AutomationExecutionFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyAsString}.
     * </p>
     * 
     * @return The aspect of the Automation execution information that should be limited.
     * @see AutomationExecutionFilterKey
     */
    public String keyAsString() {
        return key;
    }

    /**
     * <p>
     * The values used to limit the execution information associated with the filter's key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The values used to limit the execution information associated with the filter's key.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionFilter)) {
            return false;
        }
        AutomationExecutionFilter other = (AutomationExecutionFilter) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(values(), other.values());
    }

    @Override
    public String toString() {
        return ToString.builder("AutomationExecutionFilter").add("Key", keyAsString()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionFilter, T> g) {
        return obj -> g.apply((AutomationExecutionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationExecutionFilter> {
        /**
         * <p>
         * The aspect of the Automation execution information that should be limited.
         * </p>
         * 
         * @param key
         *        The aspect of the Automation execution information that should be limited.
         * @see AutomationExecutionFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The aspect of the Automation execution information that should be limited.
         * </p>
         * 
         * @param key
         *        The aspect of the Automation execution information that should be limited.
         * @see AutomationExecutionFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionFilterKey
         */
        Builder key(AutomationExecutionFilterKey key);

        /**
         * <p>
         * The values used to limit the execution information associated with the filter's key.
         * </p>
         * 
         * @param values
         *        The values used to limit the execution information associated with the filter's key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The values used to limit the execution information associated with the filter's key.
         * </p>
         * 
         * @param values
         *        The values used to limit the execution information associated with the filter's key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionFilter model) {
            key(model.key);
            values(model.values);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(AutomationExecutionFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = AutomationExecutionFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = AutomationExecutionFilterValueListCopier.copy(values);
        }

        @Override
        public AutomationExecutionFilter build() {
            return new AutomationExecutionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
