/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a specific Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationExecutionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationExecutionMetadata.Builder, AutomationExecutionMetadata> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecutionMetadata::automationExecutionId)).setter(setter(Builder::automationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build())
            .build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecutionMetadata::documentName)).setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecutionMetadata::documentVersion)).setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecutionMetadata::automationExecutionStatusAsString))
            .setter(setter(Builder::automationExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build())
            .build();

    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AutomationExecutionMetadata::executionStartTime)).setter(setter(Builder::executionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build())
            .build();

    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AutomationExecutionMetadata::executionEndTime)).setter(setter(Builder::executionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()).build();

    private static final SdkField<String> EXECUTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecutionMetadata::executedBy)).setter(setter(Builder::executedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedBy").build()).build();

    private static final SdkField<String> LOG_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecutionMetadata::logFile)).setter(setter(Builder::logFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFile").build()).build();

    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(AutomationExecutionMetadata::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD,
            DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, AUTOMATION_EXECUTION_STATUS_FIELD, EXECUTION_START_TIME_FIELD,
            EXECUTION_END_TIME_FIELD, EXECUTED_BY_FIELD, LOG_FILE_FIELD, OUTPUTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String automationExecutionId;

    private final String documentName;

    private final String documentVersion;

    private final String automationExecutionStatus;

    private final Instant executionStartTime;

    private final Instant executionEndTime;

    private final String executedBy;

    private final String logFile;

    private final Map<String, List<String>> outputs;

    private AutomationExecutionMetadata(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executedBy = builder.executedBy;
        this.logFile = builder.logFile;
        this.outputs = builder.outputs;
    }

    /**
     * <p>
     * The execution ID.
     * </p>
     * 
     * @return The execution ID.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    /**
     * <p>
     * The name of the Automation document used during execution.
     * </p>
     * 
     * @return The name of the Automation document used during execution.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The document version used during the execution.
     * </p>
     * 
     * @return The document version used during the execution.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automationExecutionStatus} will return {@link AutomationExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automationExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * @see AutomationExecutionStatus
     */
    public AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(automationExecutionStatus);
    }

    /**
     * <p>
     * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automationExecutionStatus} will return {@link AutomationExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automationExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
     * @see AutomationExecutionStatus
     */
    public String automationExecutionStatusAsString() {
        return automationExecutionStatus;
    }

    /**
     * <p>
     * The time the execution started.&gt;
     * </p>
     * 
     * @return The time the execution started.&gt;
     */
    public Instant executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * The time the execution finished. This is not populated if the execution is still in progress.
     * </p>
     * 
     * @return The time the execution finished. This is not populated if the execution is still in progress.
     */
    public Instant executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The IAM role ARN of the user who executed the Automation.
     * </p>
     * 
     * @return The IAM role ARN of the user who executed the Automation.
     */
    public String executedBy() {
        return executedBy;
    }

    /**
     * <p>
     * An Amazon S3 bucket where execution information is stored.
     * </p>
     * 
     * @return An Amazon S3 bucket where execution information is stored.
     */
    public String logFile() {
        return logFile;
    }

    /**
     * <p>
     * The list of execution outputs as defined in the Automation document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of execution outputs as defined in the Automation document.
     */
    public Map<String, List<String>> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(logFile());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionMetadata)) {
            return false;
        }
        AutomationExecutionMetadata other = (AutomationExecutionMetadata) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId())
                && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(automationExecutionStatusAsString(), other.automationExecutionStatusAsString())
                && Objects.equals(executionStartTime(), other.executionStartTime())
                && Objects.equals(executionEndTime(), other.executionEndTime())
                && Objects.equals(executedBy(), other.executedBy()) && Objects.equals(logFile(), other.logFile())
                && Objects.equals(outputs(), other.outputs());
    }

    @Override
    public String toString() {
        return ToString.builder("AutomationExecutionMetadata").add("AutomationExecutionId", automationExecutionId())
                .add("DocumentName", documentName()).add("DocumentVersion", documentVersion())
                .add("AutomationExecutionStatus", automationExecutionStatusAsString())
                .add("ExecutionStartTime", executionStartTime()).add("ExecutionEndTime", executionEndTime())
                .add("ExecutedBy", executedBy()).add("LogFile", logFile()).add("Outputs", outputs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.ofNullable(clazz.cast(automationExecutionId()));
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "AutomationExecutionStatus":
            return Optional.ofNullable(clazz.cast(automationExecutionStatusAsString()));
        case "ExecutionStartTime":
            return Optional.ofNullable(clazz.cast(executionStartTime()));
        case "ExecutionEndTime":
            return Optional.ofNullable(clazz.cast(executionEndTime()));
        case "ExecutedBy":
            return Optional.ofNullable(clazz.cast(executedBy()));
        case "LogFile":
            return Optional.ofNullable(clazz.cast(logFile()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionMetadata, T> g) {
        return obj -> g.apply((AutomationExecutionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationExecutionMetadata> {
        /**
         * <p>
         * The execution ID.
         * </p>
         * 
         * @param automationExecutionId
         *        The execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);

        /**
         * <p>
         * The name of the Automation document used during execution.
         * </p>
         * 
         * @param documentName
         *        The name of the Automation document used during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The document version used during the execution.
         * </p>
         * 
         * @param documentVersion
         *        The document version used during the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or
         *        Cancelled.
         * @see AutomationExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(String automationExecutionStatus);

        /**
         * <p>
         * The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or Cancelled.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The status of the execution. Valid values include: Running, Succeeded, Failed, Timed out, or
         *        Cancelled.
         * @see AutomationExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus);

        /**
         * <p>
         * The time the execution started.&gt;
         * </p>
         * 
         * @param executionStartTime
         *        The time the execution started.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Instant executionStartTime);

        /**
         * <p>
         * The time the execution finished. This is not populated if the execution is still in progress.
         * </p>
         * 
         * @param executionEndTime
         *        The time the execution finished. This is not populated if the execution is still in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Instant executionEndTime);

        /**
         * <p>
         * The IAM role ARN of the user who executed the Automation.
         * </p>
         * 
         * @param executedBy
         *        The IAM role ARN of the user who executed the Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedBy(String executedBy);

        /**
         * <p>
         * An Amazon S3 bucket where execution information is stored.
         * </p>
         * 
         * @param logFile
         *        An Amazon S3 bucket where execution information is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFile(String logFile);

        /**
         * <p>
         * The list of execution outputs as defined in the Automation document.
         * </p>
         * 
         * @param outputs
         *        The list of execution outputs as defined in the Automation document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Map<String, ? extends Collection<String>> outputs);
    }

    static final class BuilderImpl implements Builder {
        private String automationExecutionId;

        private String documentName;

        private String documentVersion;

        private String automationExecutionStatus;

        private Instant executionStartTime;

        private Instant executionEndTime;

        private String executedBy;

        private String logFile;

        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionMetadata model) {
            automationExecutionId(model.automationExecutionId);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            automationExecutionStatus(model.automationExecutionStatus);
            executionStartTime(model.executionStartTime);
            executionEndTime(model.executionEndTime);
            executedBy(model.executedBy);
            logFile(model.logFile);
            outputs(model.outputs);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAutomationExecutionStatus() {
            return automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final Instant getExecutionStartTime() {
            return executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getExecutedBy() {
            return executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        public final String getLogFile() {
            return logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        @Override
        public AutomationExecutionMetadata build() {
            return new AutomationExecutionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
