/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommandInvocationResponse extends SsmResponse implements
        ToCopyableBuilder<GetCommandInvocationResponse.Builder, GetCommandInvocationResponse> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::documentName)).setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> PLUGIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::pluginName)).setter(setter(Builder::pluginName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginName").build()).build();

    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetCommandInvocationResponse::responseCode)).setter(setter(Builder::responseCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()).build();

    private static final SdkField<String> EXECUTION_START_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::executionStartDateTime)).setter(setter(Builder::executionStartDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartDateTime").build())
            .build();

    private static final SdkField<String> EXECUTION_ELAPSED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::executionElapsedTime)).setter(setter(Builder::executionElapsedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionElapsedTime").build())
            .build();

    private static final SdkField<String> EXECUTION_END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::executionEndDateTime)).setter(setter(Builder::executionEndDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndDateTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::statusDetails)).setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()).build();

    private static final SdkField<String> STANDARD_OUTPUT_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::standardOutputContent)).setter(setter(Builder::standardOutputContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardOutputContent").build())
            .build();

    private static final SdkField<String> STANDARD_OUTPUT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::standardOutputUrl)).setter(setter(Builder::standardOutputUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardOutputUrl").build()).build();

    private static final SdkField<String> STANDARD_ERROR_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::standardErrorContent)).setter(setter(Builder::standardErrorContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardErrorContent").build())
            .build();

    private static final SdkField<String> STANDARD_ERROR_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationResponse::standardErrorUrl)).setter(setter(Builder::standardErrorUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardErrorUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            INSTANCE_ID_FIELD, COMMENT_FIELD, DOCUMENT_NAME_FIELD, PLUGIN_NAME_FIELD, RESPONSE_CODE_FIELD,
            EXECUTION_START_DATE_TIME_FIELD, EXECUTION_ELAPSED_TIME_FIELD, EXECUTION_END_DATE_TIME_FIELD, STATUS_FIELD,
            STATUS_DETAILS_FIELD, STANDARD_OUTPUT_CONTENT_FIELD, STANDARD_OUTPUT_URL_FIELD, STANDARD_ERROR_CONTENT_FIELD,
            STANDARD_ERROR_URL_FIELD));

    private final String commandId;

    private final String instanceId;

    private final String comment;

    private final String documentName;

    private final String pluginName;

    private final Integer responseCode;

    private final String executionStartDateTime;

    private final String executionElapsedTime;

    private final String executionEndDateTime;

    private final String status;

    private final String statusDetails;

    private final String standardOutputContent;

    private final String standardOutputUrl;

    private final String standardErrorContent;

    private final String standardErrorUrl;

    private GetCommandInvocationResponse(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.comment = builder.comment;
        this.documentName = builder.documentName;
        this.pluginName = builder.pluginName;
        this.responseCode = builder.responseCode;
        this.executionStartDateTime = builder.executionStartDateTime;
        this.executionElapsedTime = builder.executionElapsedTime;
        this.executionEndDateTime = builder.executionEndDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.standardOutputContent = builder.standardOutputContent;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorContent = builder.standardErrorContent;
        this.standardErrorUrl = builder.standardErrorUrl;
    }

    /**
     * <p>
     * The parent command ID of the invocation plugin.
     * </p>
     * 
     * @return The parent command ID of the invocation plugin.
     */
    public String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2 instance or an
     * instance in your hybrid environment that is configured for Systems Manager.
     * </p>
     * 
     * @return The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2 instance
     *         or an instance in your hybrid environment that is configured for Systems Manager.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The comment text for the command.
     * </p>
     * 
     * @return The comment text for the command.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * The name of the document that was executed. For example, AWS-RunShellScript.
     * </p>
     * 
     * @return The name of the document that was executed. For example, AWS-RunShellScript.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a plugin.
     * </p>
     * 
     * @return The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a plugin.
     */
    public String pluginName() {
        return pluginName;
    }

    /**
     * <p>
     * The error level response code for the plugin script. If the response code is -1, then the command has not started
     * executing on the instance, or it was not received by the instance.
     * </p>
     * 
     * @return The error level response code for the plugin script. If the response code is -1, then the command has not
     *         started executing on the instance, or it was not received by the instance.
     */
    public Integer responseCode() {
        return responseCode;
    }

    /**
     * <p>
     * The date and time the plugin started executing. Date and time are written in ISO 8601 format. For example, June
     * 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the <code>InvokedBefore</code>
     * filter.
     * </p>
     * <p>
     * <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
     * </p>
     * <p>
     * If the plugin has not started to execute, the string is empty.
     * </p>
     * 
     * @return The date and time the plugin started executing. Date and time are written in ISO 8601 format. For
     *         example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
     *         <code>InvokedBefore</code> filter.</p>
     *         <p>
     *         <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
     *         </p>
     *         <p>
     *         If the plugin has not started to execute, the string is empty.
     */
    public String executionStartDateTime() {
        return executionStartDateTime;
    }

    /**
     * <p>
     * Duration since ExecutionStartDateTime.
     * </p>
     * 
     * @return Duration since ExecutionStartDateTime.
     */
    public String executionElapsedTime() {
        return executionElapsedTime;
    }

    /**
     * <p>
     * The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For example,
     * June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the <code>InvokedAfter</code>
     * filter.
     * </p>
     * <p>
     * <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
     * </p>
     * <p>
     * If the plugin has not started to execute, the string is empty.
     * </p>
     * 
     * @return The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For
     *         example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
     *         <code>InvokedAfter</code> filter.</p>
     *         <p>
     *         <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
     *         </p>
     *         <p>
     *         If the plugin has not started to execute, the string is empty.
     */
    public String executionEndDateTime() {
        return executionEndDateTime;
    }

    /**
     * <p>
     * The status of the parent command for this invocation. This status can be different than StatusDetails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandInvocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the parent command for this invocation. This status can be different than StatusDetails.
     * @see CommandInvocationStatus
     */
    public CommandInvocationStatus status() {
        return CommandInvocationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the parent command for this invocation. This status can be different than StatusDetails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandInvocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the parent command for this invocation. This status can be different than StatusDetails.
     * @see CommandInvocationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed status of the command execution for an invocation. StatusDetails includes more information than Status
     * because it includes states resulting from error and concurrency control parameters. StatusDetails can show
     * different results than Status. For more information about these statuses, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command
     * Status</a>. StatusDetails can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The command has not been sent to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * In Progress: The command has been sent to the instance but has not reached a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delayed: The system attempted to send the command to the target, but the target was not available. The instance
     * might not be available because of network issues, the instance was stopped, etc. The system will try to deliver
     * the command again.
     * </p>
     * </li>
     * <li>
     * <p>
     * Success: The command or plugin was executed successfully. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired. Delivery
     * timeouts do not count against the parent command's MaxErrors limit, but they do contribute to whether the parent
     * command status is Success or Incomplete. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Execution Timed Out: The command started to execute on the instance, but the execution was not complete before
     * the timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This is a
     * terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed: The command wasn't executed successfully on the instance. For a plugin, this indicates that the result
     * code was not zero. For a command invocation, this indicates that the result code for one or more plugins was not
     * zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Canceled: The command was terminated before it was completed. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not be
     * responding. Undeliverable invocations don't count against the parent command's MaxErrors limit and don't
     * contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by
     * the system. This is a terminal state.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A detailed status of the command execution for an invocation. StatusDetails includes more information
     *         than Status because it includes states resulting from error and concurrency control parameters.
     *         StatusDetails can show different results than Status. For more information about these statuses, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command
     *         Status</a>. StatusDetails can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The command has not been sent to the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In Progress: The command has been sent to the instance but has not reached a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delayed: The system attempted to send the command to the target, but the target was not available. The
     *         instance might not be available because of network issues, the instance was stopped, etc. The system will
     *         try to deliver the command again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Success: The command or plugin was executed successfully. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired.
     *         Delivery timeouts do not count against the parent command's MaxErrors limit, but they do contribute to
     *         whether the parent command status is Success or Incomplete. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Execution Timed Out: The command started to execute on the instance, but the execution was not complete
     *         before the timeout expired. Execution timeouts count against the MaxErrors limit of the parent command.
     *         This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed: The command wasn't executed successfully on the instance. For a plugin, this indicates that the
     *         result code was not zero. For a command invocation, this indicates that the result code for one or more
     *         plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This
     *         is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Canceled: The command was terminated before it was completed. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not
     *         be responding. Undeliverable invocations don't count against the parent command's MaxErrors limit and
     *         don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were
     *         canceled by the system. This is a terminal state.
     *         </p>
     *         </li>
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The first 24,000 characters written by the plugin to stdout. If the command has not finished executing, if
     * ExecutionStatus is neither Succeeded nor Failed, then this string is empty.
     * </p>
     * 
     * @return The first 24,000 characters written by the plugin to stdout. If the command has not finished executing,
     *         if ExecutionStatus is neither Succeeded nor Failed, then this string is empty.
     */
    public String standardOutputContent() {
        return standardOutputContent;
    }

    /**
     * <p>
     * The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was not
     * specified, then this string is empty.
     * </p>
     * 
     * @return The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was
     *         not specified, then this string is empty.
     */
    public String standardOutputUrl() {
        return standardOutputUrl;
    }

    /**
     * <p>
     * The first 8,000 characters written by the plugin to stderr. If the command has not finished executing, then this
     * string is empty.
     * </p>
     * 
     * @return The first 8,000 characters written by the plugin to stderr. If the command has not finished executing,
     *         then this string is empty.
     */
    public String standardErrorContent() {
        return standardErrorContent;
    }

    /**
     * <p>
     * The URL for the complete text written by the plugin to stderr. If the command has not finished executing, then
     * this string is empty.
     * </p>
     * 
     * @return The URL for the complete text written by the plugin to stderr. If the command has not finished executing,
     *         then this string is empty.
     */
    public String standardErrorUrl() {
        return standardErrorUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(pluginName());
        hashCode = 31 * hashCode + Objects.hashCode(responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionElapsedTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutputContent());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(standardErrorContent());
        hashCode = 31 * hashCode + Objects.hashCode(standardErrorUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandInvocationResponse)) {
            return false;
        }
        GetCommandInvocationResponse other = (GetCommandInvocationResponse) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(comment(), other.comment()) && Objects.equals(documentName(), other.documentName())
                && Objects.equals(pluginName(), other.pluginName()) && Objects.equals(responseCode(), other.responseCode())
                && Objects.equals(executionStartDateTime(), other.executionStartDateTime())
                && Objects.equals(executionElapsedTime(), other.executionElapsedTime())
                && Objects.equals(executionEndDateTime(), other.executionEndDateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(standardOutputContent(), other.standardOutputContent())
                && Objects.equals(standardOutputUrl(), other.standardOutputUrl())
                && Objects.equals(standardErrorContent(), other.standardErrorContent())
                && Objects.equals(standardErrorUrl(), other.standardErrorUrl());
    }

    @Override
    public String toString() {
        return ToString.builder("GetCommandInvocationResponse").add("CommandId", commandId()).add("InstanceId", instanceId())
                .add("Comment", comment()).add("DocumentName", documentName()).add("PluginName", pluginName())
                .add("ResponseCode", responseCode()).add("ExecutionStartDateTime", executionStartDateTime())
                .add("ExecutionElapsedTime", executionElapsedTime()).add("ExecutionEndDateTime", executionEndDateTime())
                .add("Status", statusAsString()).add("StatusDetails", statusDetails())
                .add("StandardOutputContent", standardOutputContent()).add("StandardOutputUrl", standardOutputUrl())
                .add("StandardErrorContent", standardErrorContent()).add("StandardErrorUrl", standardErrorUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "PluginName":
            return Optional.ofNullable(clazz.cast(pluginName()));
        case "ResponseCode":
            return Optional.ofNullable(clazz.cast(responseCode()));
        case "ExecutionStartDateTime":
            return Optional.ofNullable(clazz.cast(executionStartDateTime()));
        case "ExecutionElapsedTime":
            return Optional.ofNullable(clazz.cast(executionElapsedTime()));
        case "ExecutionEndDateTime":
            return Optional.ofNullable(clazz.cast(executionEndDateTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "StandardOutputContent":
            return Optional.ofNullable(clazz.cast(standardOutputContent()));
        case "StandardOutputUrl":
            return Optional.ofNullable(clazz.cast(standardOutputUrl()));
        case "StandardErrorContent":
            return Optional.ofNullable(clazz.cast(standardErrorContent()));
        case "StandardErrorUrl":
            return Optional.ofNullable(clazz.cast(standardErrorUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCommandInvocationResponse, T> g) {
        return obj -> g.apply((GetCommandInvocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCommandInvocationResponse> {
        /**
         * <p>
         * The parent command ID of the invocation plugin.
         * </p>
         * 
         * @param commandId
         *        The parent command ID of the invocation plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2 instance or
         * an instance in your hybrid environment that is configured for Systems Manager.
         * </p>
         * 
         * @param instanceId
         *        The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2
         *        instance or an instance in your hybrid environment that is configured for Systems Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The comment text for the command.
         * </p>
         * 
         * @param comment
         *        The comment text for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The name of the document that was executed. For example, AWS-RunShellScript.
         * </p>
         * 
         * @param documentName
         *        The name of the document that was executed. For example, AWS-RunShellScript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a plugin.
         * </p>
         * 
         * @param pluginName
         *        The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a
         *        plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginName(String pluginName);

        /**
         * <p>
         * The error level response code for the plugin script. If the response code is -1, then the command has not
         * started executing on the instance, or it was not received by the instance.
         * </p>
         * 
         * @param responseCode
         *        The error level response code for the plugin script. If the response code is -1, then the command has
         *        not started executing on the instance, or it was not received by the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCode(Integer responseCode);

        /**
         * <p>
         * The date and time the plugin started executing. Date and time are written in ISO 8601 format. For example,
         * June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
         * <code>InvokedBefore</code> filter.
         * </p>
         * <p>
         * <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
         * </p>
         * <p>
         * If the plugin has not started to execute, the string is empty.
         * </p>
         * 
         * @param executionStartDateTime
         *        The date and time the plugin started executing. Date and time are written in ISO 8601 format. For
         *        example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
         *        <code>InvokedBefore</code> filter.</p>
         *        <p>
         *        <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
         *        </p>
         *        <p>
         *        If the plugin has not started to execute, the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartDateTime(String executionStartDateTime);

        /**
         * <p>
         * Duration since ExecutionStartDateTime.
         * </p>
         * 
         * @param executionElapsedTime
         *        Duration since ExecutionStartDateTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionElapsedTime(String executionElapsedTime);

        /**
         * <p>
         * The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For
         * example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
         * <code>InvokedAfter</code> filter.
         * </p>
         * <p>
         * <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
         * </p>
         * <p>
         * If the plugin has not started to execute, the string is empty.
         * </p>
         * 
         * @param executionEndDateTime
         *        The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For
         *        example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
         *        <code>InvokedAfter</code> filter.</p>
         *        <p>
         *        <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
         *        </p>
         *        <p>
         *        If the plugin has not started to execute, the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndDateTime(String executionEndDateTime);

        /**
         * <p>
         * The status of the parent command for this invocation. This status can be different than StatusDetails.
         * </p>
         * 
         * @param status
         *        The status of the parent command for this invocation. This status can be different than StatusDetails.
         * @see CommandInvocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandInvocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the parent command for this invocation. This status can be different than StatusDetails.
         * </p>
         * 
         * @param status
         *        The status of the parent command for this invocation. This status can be different than StatusDetails.
         * @see CommandInvocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandInvocationStatus
         */
        Builder status(CommandInvocationStatus status);

        /**
         * <p>
         * A detailed status of the command execution for an invocation. StatusDetails includes more information than
         * Status because it includes states resulting from error and concurrency control parameters. StatusDetails can
         * show different results than Status. For more information about these statuses, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command
         * Status</a>. StatusDetails can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The command has not been sent to the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: The command has been sent to the instance but has not reached a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delayed: The system attempted to send the command to the target, but the target was not available. The
         * instance might not be available because of network issues, the instance was stopped, etc. The system will try
         * to deliver the command again.
         * </p>
         * </li>
         * <li>
         * <p>
         * Success: The command or plugin was executed successfully. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired.
         * Delivery timeouts do not count against the parent command's MaxErrors limit, but they do contribute to
         * whether the parent command status is Success or Incomplete. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Execution Timed Out: The command started to execute on the instance, but the execution was not complete
         * before the timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This
         * is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: The command wasn't executed successfully on the instance. For a plugin, this indicates that the
         * result code was not zero. For a command invocation, this indicates that the result code for one or more
         * plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This is a
         * terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Canceled: The command was terminated before it was completed. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not be
         * responding. Undeliverable invocations don't count against the parent command's MaxErrors limit and don't
         * contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled
         * by the system. This is a terminal state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusDetails
         *        A detailed status of the command execution for an invocation. StatusDetails includes more information
         *        than Status because it includes states resulting from error and concurrency control parameters.
         *        StatusDetails can show different results than Status. For more information about these statuses, see
         *        <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run
         *        Command Status</a>. StatusDetails can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The command has not been sent to the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: The command has been sent to the instance but has not reached a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delayed: The system attempted to send the command to the target, but the target was not available. The
         *        instance might not be available because of network issues, the instance was stopped, etc. The system
         *        will try to deliver the command again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Success: The command or plugin was executed successfully. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired.
         *        Delivery timeouts do not count against the parent command's MaxErrors limit, but they do contribute to
         *        whether the parent command status is Success or Incomplete. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Execution Timed Out: The command started to execute on the instance, but the execution was not
         *        complete before the timeout expired. Execution timeouts count against the MaxErrors limit of the
         *        parent command. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: The command wasn't executed successfully on the instance. For a plugin, this indicates that
         *        the result code was not zero. For a command invocation, this indicates that the result code for one or
         *        more plugins was not zero. Invocation failures count against the MaxErrors limit of the parent
         *        command. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Canceled: The command was terminated before it was completed. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Undeliverable: The command can't be delivered to the instance. The instance might not exist or might
         *        not be responding. Undeliverable invocations don't count against the parent command's MaxErrors limit
         *        and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal
         *        state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were
         *        canceled by the system. This is a terminal state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The first 24,000 characters written by the plugin to stdout. If the command has not finished executing, if
         * ExecutionStatus is neither Succeeded nor Failed, then this string is empty.
         * </p>
         * 
         * @param standardOutputContent
         *        The first 24,000 characters written by the plugin to stdout. If the command has not finished
         *        executing, if ExecutionStatus is neither Succeeded nor Failed, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputContent(String standardOutputContent);

        /**
         * <p>
         * The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was not
         * specified, then this string is empty.
         * </p>
         * 
         * @param standardOutputUrl
         *        The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was
         *        not specified, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputUrl(String standardOutputUrl);

        /**
         * <p>
         * The first 8,000 characters written by the plugin to stderr. If the command has not finished executing, then
         * this string is empty.
         * </p>
         * 
         * @param standardErrorContent
         *        The first 8,000 characters written by the plugin to stderr. If the command has not finished executing,
         *        then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardErrorContent(String standardErrorContent);

        /**
         * <p>
         * The URL for the complete text written by the plugin to stderr. If the command has not finished executing,
         * then this string is empty.
         * </p>
         * 
         * @param standardErrorUrl
         *        The URL for the complete text written by the plugin to stderr. If the command has not finished
         *        executing, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardErrorUrl(String standardErrorUrl);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String commandId;

        private String instanceId;

        private String comment;

        private String documentName;

        private String pluginName;

        private Integer responseCode;

        private String executionStartDateTime;

        private String executionElapsedTime;

        private String executionEndDateTime;

        private String status;

        private String statusDetails;

        private String standardOutputContent;

        private String standardOutputUrl;

        private String standardErrorContent;

        private String standardErrorUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandInvocationResponse model) {
            super(model);
            commandId(model.commandId);
            instanceId(model.instanceId);
            comment(model.comment);
            documentName(model.documentName);
            pluginName(model.pluginName);
            responseCode(model.responseCode);
            executionStartDateTime(model.executionStartDateTime);
            executionElapsedTime(model.executionElapsedTime);
            executionEndDateTime(model.executionEndDateTime);
            status(model.status);
            statusDetails(model.statusDetails);
            standardOutputContent(model.standardOutputContent);
            standardOutputUrl(model.standardOutputUrl);
            standardErrorContent(model.standardErrorContent);
            standardErrorUrl(model.standardErrorUrl);
        }

        public final String getCommandId() {
            return commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getPluginName() {
            return pluginName;
        }

        @Override
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public final Integer getResponseCode() {
            return responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public final String getExecutionStartDateTime() {
            return executionStartDateTime;
        }

        @Override
        public final Builder executionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
            return this;
        }

        public final void setExecutionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
        }

        public final String getExecutionElapsedTime() {
            return executionElapsedTime;
        }

        @Override
        public final Builder executionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
            return this;
        }

        public final void setExecutionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
        }

        public final String getExecutionEndDateTime() {
            return executionEndDateTime;
        }

        @Override
        public final Builder executionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
            return this;
        }

        public final void setExecutionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandInvocationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getStandardOutputContent() {
            return standardOutputContent;
        }

        @Override
        public final Builder standardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
            return this;
        }

        public final void setStandardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
        }

        public final String getStandardOutputUrl() {
            return standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorContent() {
            return standardErrorContent;
        }

        @Override
        public final Builder standardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
            return this;
        }

        public final void setStandardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
        }

        public final String getStandardErrorUrl() {
            return standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        @Override
        public GetCommandInvocationResponse build() {
            return new GetCommandInvocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
