/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Maintenance Window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindowIdentity implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceWindowIdentity.Builder, MaintenanceWindowIdentity> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MaintenanceWindowIdentity::windowId)).setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MaintenanceWindowIdentity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MaintenanceWindowIdentity::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(MaintenanceWindowIdentity::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MaintenanceWindowIdentity::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MaintenanceWindowIdentity::cutoff)).setter(setter(Builder::cutoff))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, ENABLED_FIELD, DURATION_FIELD, CUTOFF_FIELD));

    private static final long serialVersionUID = 1L;

    private final String windowId;

    private final String name;

    private final String description;

    private final Boolean enabled;

    private final Integer duration;

    private final Integer cutoff;

    private MaintenanceWindowIdentity(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
    }

    /**
     * <p>
     * The ID of the Maintenance Window.
     * </p>
     * 
     * @return The ID of the Maintenance Window.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The name of the Maintenance Window.
     * </p>
     * 
     * @return The name of the Maintenance Window.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the Maintenance Window.
     * </p>
     * 
     * @return A description of the Maintenance Window.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Whether the Maintenance Window is enabled.
     * </p>
     * 
     * @return Whether the Maintenance Window is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The duration of the Maintenance Window in hours.
     * </p>
     * 
     * @return The duration of the Maintenance Window in hours.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for
     * execution.
     * </p>
     * 
     * @return The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new
     *         tasks for execution.
     */
    public Integer cutoff() {
        return cutoff;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(cutoff());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowIdentity)) {
            return false;
        }
        MaintenanceWindowIdentity other = (MaintenanceWindowIdentity) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(duration(), other.duration()) && Objects.equals(cutoff(), other.cutoff());
    }

    @Override
    public String toString() {
        return ToString.builder("MaintenanceWindowIdentity").add("WindowId", windowId()).add("Name", name())
                .add("Description", description()).add("Enabled", enabled()).add("Duration", duration()).add("Cutoff", cutoff())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Cutoff":
            return Optional.ofNullable(clazz.cast(cutoff()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowIdentity, T> g) {
        return obj -> g.apply((MaintenanceWindowIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindowIdentity> {
        /**
         * <p>
         * The ID of the Maintenance Window.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The name of the Maintenance Window.
         * </p>
         * 
         * @param name
         *        The name of the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the Maintenance Window.
         * </p>
         * 
         * @param description
         *        A description of the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the Maintenance Window is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether the Maintenance Window is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The duration of the Maintenance Window in hours.
         * </p>
         * 
         * @param duration
         *        The duration of the Maintenance Window in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks
         * for execution.
         * </p>
         * 
         * @param cutoff
         *        The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new
         *        tasks for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cutoff(Integer cutoff);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private String name;

        private String description;

        private Boolean enabled;

        private Integer duration;

        private Integer cutoff;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowIdentity model) {
            windowId(model.windowId);
            name(model.name);
            description(model.description);
            enabled(model.enabled);
            duration(model.duration);
            cutoff(model.cutoff);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        @Override
        public MaintenanceWindowIdentity build() {
            return new MaintenanceWindowIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
