/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an approval rule for a patch baseline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatchRule implements SdkPojo, Serializable, ToCopyableBuilder<PatchRule.Builder, PatchRule> {
    private static final SdkField<PatchFilterGroup> PATCH_FILTER_GROUP_FIELD = SdkField
            .<PatchFilterGroup> builder(MarshallingType.SDK_POJO).getter(getter(PatchRule::patchFilterGroup))
            .setter(setter(Builder::patchFilterGroup)).constructor(PatchFilterGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchFilterGroup").build()).build();

    private static final SdkField<String> COMPLIANCE_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PatchRule::complianceLevelAsString)).setter(setter(Builder::complianceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceLevel").build()).build();

    private static final SdkField<Integer> APPROVE_AFTER_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PatchRule::approveAfterDays)).setter(setter(Builder::approveAfterDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproveAfterDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_FILTER_GROUP_FIELD,
            COMPLIANCE_LEVEL_FIELD, APPROVE_AFTER_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final PatchFilterGroup patchFilterGroup;

    private final String complianceLevel;

    private final Integer approveAfterDays;

    private PatchRule(BuilderImpl builder) {
        this.patchFilterGroup = builder.patchFilterGroup;
        this.complianceLevel = builder.complianceLevel;
        this.approveAfterDays = builder.approveAfterDays;
    }

    /**
     * <p>
     * The patch filter group that defines the criteria for the rule.
     * </p>
     * 
     * @return The patch filter group that defines the criteria for the rule.
     */
    public PatchFilterGroup patchFilterGroup() {
        return patchFilterGroup;
    }

    /**
     * <p>
     * A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels
     * include the following: Unspecified, Critical, High, Medium, Low, and Informational.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceLevel}
     * will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #complianceLevelAsString}.
     * </p>
     * 
     * @return A compliance severity level for all approved patches in a patch baseline. Valid compliance severity
     *         levels include the following: Unspecified, Critical, High, Medium, Low, and Informational.
     * @see PatchComplianceLevel
     */
    public PatchComplianceLevel complianceLevel() {
        return PatchComplianceLevel.fromValue(complianceLevel);
    }

    /**
     * <p>
     * A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels
     * include the following: Unspecified, Critical, High, Medium, Low, and Informational.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceLevel}
     * will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #complianceLevelAsString}.
     * </p>
     * 
     * @return A compliance severity level for all approved patches in a patch baseline. Valid compliance severity
     *         levels include the following: Unspecified, Critical, High, Medium, Low, and Informational.
     * @see PatchComplianceLevel
     */
    public String complianceLevelAsString() {
        return complianceLevel;
    }

    /**
     * <p>
     * The number of days after the release date of each patch matched by the rule the patch is marked as approved in
     * the patch baseline.
     * </p>
     * 
     * @return The number of days after the release date of each patch matched by the rule the patch is marked as
     *         approved in the patch baseline.
     */
    public Integer approveAfterDays() {
        return approveAfterDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patchFilterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(complianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(approveAfterDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRule)) {
            return false;
        }
        PatchRule other = (PatchRule) obj;
        return Objects.equals(patchFilterGroup(), other.patchFilterGroup())
                && Objects.equals(complianceLevelAsString(), other.complianceLevelAsString())
                && Objects.equals(approveAfterDays(), other.approveAfterDays());
    }

    @Override
    public String toString() {
        return ToString.builder("PatchRule").add("PatchFilterGroup", patchFilterGroup())
                .add("ComplianceLevel", complianceLevelAsString()).add("ApproveAfterDays", approveAfterDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchFilterGroup":
            return Optional.ofNullable(clazz.cast(patchFilterGroup()));
        case "ComplianceLevel":
            return Optional.ofNullable(clazz.cast(complianceLevelAsString()));
        case "ApproveAfterDays":
            return Optional.ofNullable(clazz.cast(approveAfterDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchRule, T> g) {
        return obj -> g.apply((PatchRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatchRule> {
        /**
         * <p>
         * The patch filter group that defines the criteria for the rule.
         * </p>
         * 
         * @param patchFilterGroup
         *        The patch filter group that defines the criteria for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchFilterGroup(PatchFilterGroup patchFilterGroup);

        /**
         * <p>
         * The patch filter group that defines the criteria for the rule.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchFilterGroup.Builder} avoiding the need to
         * create one manually via {@link PatchFilterGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchFilterGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #patchFilterGroup(PatchFilterGroup)}.
         * 
         * @param patchFilterGroup
         *        a consumer that will call methods on {@link PatchFilterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchFilterGroup(PatchFilterGroup)
         */
        default Builder patchFilterGroup(Consumer<PatchFilterGroup.Builder> patchFilterGroup) {
            return patchFilterGroup(PatchFilterGroup.builder().applyMutation(patchFilterGroup).build());
        }

        /**
         * <p>
         * A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels
         * include the following: Unspecified, Critical, High, Medium, Low, and Informational.
         * </p>
         * 
         * @param complianceLevel
         *        A compliance severity level for all approved patches in a patch baseline. Valid compliance severity
         *        levels include the following: Unspecified, Critical, High, Medium, Low, and Informational.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder complianceLevel(String complianceLevel);

        /**
         * <p>
         * A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels
         * include the following: Unspecified, Critical, High, Medium, Low, and Informational.
         * </p>
         * 
         * @param complianceLevel
         *        A compliance severity level for all approved patches in a patch baseline. Valid compliance severity
         *        levels include the following: Unspecified, Critical, High, Medium, Low, and Informational.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder complianceLevel(PatchComplianceLevel complianceLevel);

        /**
         * <p>
         * The number of days after the release date of each patch matched by the rule the patch is marked as approved
         * in the patch baseline.
         * </p>
         * 
         * @param approveAfterDays
         *        The number of days after the release date of each patch matched by the rule the patch is marked as
         *        approved in the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approveAfterDays(Integer approveAfterDays);
    }

    static final class BuilderImpl implements Builder {
        private PatchFilterGroup patchFilterGroup;

        private String complianceLevel;

        private Integer approveAfterDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRule model) {
            patchFilterGroup(model.patchFilterGroup);
            complianceLevel(model.complianceLevel);
            approveAfterDays(model.approveAfterDays);
        }

        public final PatchFilterGroup.Builder getPatchFilterGroup() {
            return patchFilterGroup != null ? patchFilterGroup.toBuilder() : null;
        }

        @Override
        public final Builder patchFilterGroup(PatchFilterGroup patchFilterGroup) {
            this.patchFilterGroup = patchFilterGroup;
            return this;
        }

        public final void setPatchFilterGroup(PatchFilterGroup.BuilderImpl patchFilterGroup) {
            this.patchFilterGroup = patchFilterGroup != null ? patchFilterGroup.build() : null;
        }

        public final String getComplianceLevel() {
            return complianceLevel;
        }

        @Override
        public final Builder complianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
            return this;
        }

        @Override
        public final Builder complianceLevel(PatchComplianceLevel complianceLevel) {
            this.complianceLevel(complianceLevel.toString());
            return this;
        }

        public final void setComplianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
        }

        public final Integer getApproveAfterDays() {
            return approveAfterDays;
        }

        @Override
        public final Builder approveAfterDays(Integer approveAfterDays) {
            this.approveAfterDays = approveAfterDays;
            return this;
        }

        public final void setApproveAfterDays(Integer approveAfterDays) {
            this.approveAfterDays = approveAfterDays;
        }

        @Override
        public PatchRule build() {
            return new PatchRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
