/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.services.ssm.model.StepExecutionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationExecution> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::automationExecutionId)).setter(AutomationExecution.setter(Builder::automationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::documentName)).setter(AutomationExecution.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::documentVersion)).setter(AutomationExecution.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutomationExecution.getter(AutomationExecution::executionStartTime)).setter(AutomationExecution.setter(Builder::executionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutomationExecution.getter(AutomationExecution::executionEndTime)).setter(AutomationExecution.setter(Builder::executionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()}).build();
    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::automationExecutionStatusAsString)).setter(AutomationExecution.setter(Builder::automationExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build()}).build();
    private static final SdkField<List<StepExecution>> STEP_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutomationExecution.getter(AutomationExecution::stepExecutions)).setter(AutomationExecution.setter(Builder::stepExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AutomationExecution.getter(AutomationExecution::parameters)).setter(AutomationExecution.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AutomationExecution.getter(AutomationExecution::outputs)).setter(AutomationExecution.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::failureMessage)).setter(AutomationExecution.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, AUTOMATION_EXECUTION_STATUS_FIELD, STEP_EXECUTIONS_FIELD, PARAMETERS_FIELD, OUTPUTS_FIELD, FAILURE_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String automationExecutionStatus;
    private final List<StepExecution> stepExecutions;
    private final Map<String, List<String>> parameters;
    private final Map<String, List<String>> outputs;
    private final String failureMessage;

    private AutomationExecution(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.stepExecutions = builder.stepExecutions;
        this.parameters = builder.parameters;
        this.outputs = builder.outputs;
        this.failureMessage = builder.failureMessage;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Instant executionStartTime() {
        return this.executionStartTime;
    }

    public Instant executionEndTime() {
        return this.executionEndTime;
    }

    public AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(this.automationExecutionStatus);
    }

    public String automationExecutionStatusAsString() {
        return this.automationExecutionStatus;
    }

    public List<StepExecution> stepExecutions() {
        return this.stepExecutions;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution)obj;
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.automationExecutionStatusAsString(), other.automationExecutionStatusAsString()) && Objects.equals(this.stepExecutions(), other.stepExecutions()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public String toString() {
        return ToString.builder((String)"AutomationExecution").add("AutomationExecutionId", (Object)this.automationExecutionId()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("AutomationExecutionStatus", (Object)this.automationExecutionStatusAsString()).add("StepExecutions", this.stepExecutions()).add("Parameters", this.parameters()).add("Outputs", this.outputs()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionId()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "ExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "AutomationExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionStatusAsString()));
            }
            case "StepExecutions": {
                return Optional.ofNullable(clazz.cast(this.stepExecutions()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecution, T> g) {
        return obj -> g.apply((AutomationExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String automationExecutionStatus;
        private List<StepExecution> stepExecutions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecution model) {
            this.automationExecutionId(model.automationExecutionId);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.automationExecutionStatus(model.automationExecutionStatus);
            this.stepExecutions(model.stepExecutions);
            this.parameters(model.parameters);
            this.outputs(model.outputs);
            this.failureMessage(model.failureMessage);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getAutomationExecutionStatus() {
            return this.automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final Collection<StepExecution.Builder> getStepExecutions() {
            return this.stepExecutions != null ? (Collection)this.stepExecutions.stream().map(StepExecution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution ... stepExecutions) {
            this.stepExecutions(Arrays.asList(stepExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(Consumer<StepExecution.Builder> ... stepExecutions) {
            this.stepExecutions(Stream.of(stepExecutions).map(c -> (StepExecution)((StepExecution.Builder)StepExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStepExecutions(Collection<StepExecution.BuilderImpl> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copyFromBuilder(stepExecutions);
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public AutomationExecution build() {
            return new AutomationExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationExecution> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder stepExecutions(Collection<StepExecution> var1);

        public Builder stepExecutions(StepExecution ... var1);

        public Builder stepExecutions(Consumer<StepExecution.Builder> ... var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder failureMessage(String var1);
    }
}

