/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationExecutionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationExecutionMetadata> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationExecutionId)).setter(AutomationExecutionMetadata.setter(Builder::automationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::documentName)).setter(AutomationExecutionMetadata.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::documentVersion)).setter(AutomationExecutionMetadata.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationExecutionStatusAsString)).setter(AutomationExecutionMetadata.setter(Builder::automationExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executionStartTime)).setter(AutomationExecutionMetadata.setter(Builder::executionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executionEndTime)).setter(AutomationExecutionMetadata.setter(Builder::executionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()}).build();
    private static final SdkField<String> EXECUTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executedBy)).setter(AutomationExecutionMetadata.setter(Builder::executedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedBy").build()}).build();
    private static final SdkField<String> LOG_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::logFile)).setter(AutomationExecutionMetadata.setter(Builder::logFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFile").build()}).build();
    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::outputs)).setter(AutomationExecutionMetadata.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, AUTOMATION_EXECUTION_STATUS_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, EXECUTED_BY_FIELD, LOG_FILE_FIELD, OUTPUTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final String automationExecutionStatus;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String executedBy;
    private final String logFile;
    private final Map<String, List<String>> outputs;

    private AutomationExecutionMetadata(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executedBy = builder.executedBy;
        this.logFile = builder.logFile;
        this.outputs = builder.outputs;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(this.automationExecutionStatus);
    }

    public String automationExecutionStatusAsString() {
        return this.automationExecutionStatus;
    }

    public Instant executionStartTime() {
        return this.executionStartTime;
    }

    public Instant executionEndTime() {
        return this.executionEndTime;
    }

    public String executedBy() {
        return this.executedBy;
    }

    public String logFile() {
        return this.logFile;
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionMetadata)) {
            return false;
        }
        AutomationExecutionMetadata other = (AutomationExecutionMetadata)obj;
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.automationExecutionStatusAsString(), other.automationExecutionStatusAsString()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.executedBy(), other.executedBy()) && Objects.equals(this.logFile(), other.logFile()) && Objects.equals(this.outputs(), other.outputs());
    }

    public String toString() {
        return ToString.builder((String)"AutomationExecutionMetadata").add("AutomationExecutionId", (Object)this.automationExecutionId()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("AutomationExecutionStatus", (Object)this.automationExecutionStatusAsString()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("ExecutedBy", (Object)this.executedBy()).add("LogFile", (Object)this.logFile()).add("Outputs", this.outputs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionId()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "AutomationExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionStatusAsString()));
            }
            case "ExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "ExecutedBy": {
                return Optional.ofNullable(clazz.cast(this.executedBy()));
            }
            case "LogFile": {
                return Optional.ofNullable(clazz.cast(this.logFile()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionMetadata, T> g) {
        return obj -> g.apply((AutomationExecutionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private String automationExecutionStatus;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String executedBy;
        private String logFile;
        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionMetadata model) {
            this.automationExecutionId(model.automationExecutionId);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.automationExecutionStatus(model.automationExecutionStatus);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.executedBy(model.executedBy);
            this.logFile(model.logFile);
            this.outputs(model.outputs);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAutomationExecutionStatus() {
            return this.automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getExecutedBy() {
            return this.executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        public final String getLogFile() {
            return this.logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public AutomationExecutionMetadata build() {
            return new AutomationExecutionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationExecutionMetadata> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder executedBy(String var1);

        public Builder logFile(String var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);
    }
}

