/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.AssociationStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AssociationStatus implements StructuredPojo, ToCopyableBuilder<AssociationStatus.Builder, AssociationStatus> {
    private final Instant dateValue;

    private final String name;

    private final String message;

    private final String additionalInfo;

    private AssociationStatus(BuilderImpl builder) {
        this.dateValue = builder.dateValue;
        this.name = builder.name;
        this.message = builder.message;
        this.additionalInfo = builder.additionalInfo;
    }

    /**
     * <p>
     * The date when the status changed.
     * </p>
     * 
     * @return The date when the status changed.
     */
    public Instant date() {
        return dateValue;
    }

    /**
     * <p>
     * The status.
     * </p>
     * 
     * @return The status.
     * @see AssociationStatusName
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The reason for the status.
     * </p>
     * 
     * @return The reason for the status.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * A user-defined string.
     * </p>
     * 
     * @return A user-defined string.
     */
    public String additionalInfo() {
        return additionalInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((date() == null) ? 0 : date().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((additionalInfo() == null) ? 0 : additionalInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationStatus)) {
            return false;
        }
        AssociationStatus other = (AssociationStatus) obj;
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        if (other.additionalInfo() != null && !other.additionalInfo().equals(this.additionalInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (date() != null) {
            sb.append("Date: ").append(date()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(additionalInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AssociationStatus> {
        /**
         * <p>
         * The date when the status changed.
         * </p>
         * 
         * @param dateValue
         *        The date when the status changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant dateValue);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param name
         *        The status.
         * @see AssociationStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatusName
         */
        Builder name(String name);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param name
         *        The status.
         * @see AssociationStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatusName
         */
        Builder name(AssociationStatusName name);

        /**
         * <p>
         * The reason for the status.
         * </p>
         * 
         * @param message
         *        The reason for the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * A user-defined string.
         * </p>
         * 
         * @param additionalInfo
         *        A user-defined string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);
    }

    private static final class BuilderImpl implements Builder {
        private Instant dateValue;

        private String name;

        private String message;

        private String additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationStatus model) {
            setDate(model.dateValue);
            setName(model.name);
            setMessage(model.message);
            setAdditionalInfo(model.additionalInfo);
        }

        public final Instant getDate() {
            return dateValue;
        }

        @Override
        public final Builder date(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDate(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AssociationStatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final void setName(AssociationStatusName name) {
            this.name(name.toString());
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public AssociationStatus build() {
            return new AssociationStatus(this);
        }
    }
}
