/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateActivationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateActivationRequest.Builder, CreateActivationRequest> {
    private final String description;

    private final String defaultInstanceName;

    private final String iamRole;

    private final Integer registrationLimit;

    private final Instant expirationDate;

    private CreateActivationRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.expirationDate = builder.expirationDate;
    }

    /**
     * <p>
     * A userdefined description of the resource that you want to register with Amazon EC2.
     * </p>
     * 
     * @return A userdefined description of the resource that you want to register with Amazon EC2.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you use the AWS
     * command line tools to list EC2 resources.
     * </p>
     * 
     * @return The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you use
     *         the AWS command line tools to list EC2 resources.
     */
    public String defaultInstanceName() {
        return defaultInstanceName;
    }

    /**
     * <p>
     * The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance.
     * </p>
     * 
     * @return The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance.
     */
    public String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * Specify the maximum number of managed instances you want to register. The default value is 1 instance.
     * </p>
     * 
     * @return Specify the maximum number of managed instances you want to register. The default value is 1 instance.
     */
    public Integer registrationLimit() {
        return registrationLimit;
    }

    /**
     * <p>
     * The date by which this activation request should expire. The default value is 24 hours.
     * </p>
     * 
     * @return The date by which this activation request should expire. The default value is 24 hours.
     */
    public Instant expirationDate() {
        return expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((defaultInstanceName() == null) ? 0 : defaultInstanceName().hashCode());
        hashCode = 31 * hashCode + ((iamRole() == null) ? 0 : iamRole().hashCode());
        hashCode = 31 * hashCode + ((registrationLimit() == null) ? 0 : registrationLimit().hashCode());
        hashCode = 31 * hashCode + ((expirationDate() == null) ? 0 : expirationDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivationRequest)) {
            return false;
        }
        CreateActivationRequest other = (CreateActivationRequest) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.defaultInstanceName() == null ^ this.defaultInstanceName() == null) {
            return false;
        }
        if (other.defaultInstanceName() != null && !other.defaultInstanceName().equals(this.defaultInstanceName())) {
            return false;
        }
        if (other.iamRole() == null ^ this.iamRole() == null) {
            return false;
        }
        if (other.iamRole() != null && !other.iamRole().equals(this.iamRole())) {
            return false;
        }
        if (other.registrationLimit() == null ^ this.registrationLimit() == null) {
            return false;
        }
        if (other.registrationLimit() != null && !other.registrationLimit().equals(this.registrationLimit())) {
            return false;
        }
        if (other.expirationDate() == null ^ this.expirationDate() == null) {
            return false;
        }
        if (other.expirationDate() != null && !other.expirationDate().equals(this.expirationDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (defaultInstanceName() != null) {
            sb.append("DefaultInstanceName: ").append(defaultInstanceName()).append(",");
        }
        if (iamRole() != null) {
            sb.append("IamRole: ").append(iamRole()).append(",");
        }
        if (registrationLimit() != null) {
            sb.append("RegistrationLimit: ").append(registrationLimit()).append(",");
        }
        if (expirationDate() != null) {
            sb.append("ExpirationDate: ").append(expirationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateActivationRequest> {
        /**
         * <p>
         * A userdefined description of the resource that you want to register with Amazon EC2.
         * </p>
         * 
         * @param description
         *        A userdefined description of the resource that you want to register with Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you use the
         * AWS command line tools to list EC2 resources.
         * </p>
         * 
         * @param defaultInstanceName
         *        The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you
         *        use the AWS command line tools to list EC2 resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceName(String defaultInstanceName);

        /**
         * <p>
         * The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance.
         * </p>
         * 
         * @param iamRole
         *        The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * Specify the maximum number of managed instances you want to register. The default value is 1 instance.
         * </p>
         * 
         * @param registrationLimit
         *        Specify the maximum number of managed instances you want to register. The default value is 1 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationLimit(Integer registrationLimit);

        /**
         * <p>
         * The date by which this activation request should expire. The default value is 24 hours.
         * </p>
         * 
         * @param expirationDate
         *        The date by which this activation request should expire. The default value is 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private String defaultInstanceName;

        private String iamRole;

        private Integer registrationLimit;

        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivationRequest model) {
            setDescription(model.description);
            setDefaultInstanceName(model.defaultInstanceName);
            setIamRole(model.iamRole);
            setRegistrationLimit(model.registrationLimit);
            setExpirationDate(model.expirationDate);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultInstanceName() {
            return defaultInstanceName;
        }

        @Override
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Integer getRegistrationLimit() {
            return registrationLimit;
        }

        @Override
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public CreateActivationRequest build() {
            return new CreateActivationRequest(this);
        }
    }
}
