/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDocumentPermissionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeDocumentPermissionRequest.Builder, DescribeDocumentPermissionRequest> {
    private final String name;

    private final String permissionType;

    private DescribeDocumentPermissionRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.permissionType = builder.permissionType;
    }

    /**
     * <p>
     * The name of the document for which you are the owner.
     * </p>
     * 
     * @return The name of the document for which you are the owner.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The permission type for the document. The permission type can be <i>Share</i>.
     * </p>
     * 
     * @return The permission type for the document. The permission type can be <i>Share</i>.
     * @see DocumentPermissionType
     */
    public String permissionType() {
        return permissionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((permissionType() == null) ? 0 : permissionType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionRequest)) {
            return false;
        }
        DescribeDocumentPermissionRequest other = (DescribeDocumentPermissionRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.permissionType() == null ^ this.permissionType() == null) {
            return false;
        }
        if (other.permissionType() != null && !other.permissionType().equals(this.permissionType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (permissionType() != null) {
            sb.append("PermissionType: ").append(permissionType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDocumentPermissionRequest> {
        /**
         * <p>
         * The name of the document for which you are the owner.
         * </p>
         * 
         * @param name
         *        The name of the document for which you are the owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The permission type for the document. The permission type can be <i>Share</i>.
         * </p>
         * 
         * @param permissionType
         *        The permission type for the document. The permission type can be <i>Share</i>.
         * @see DocumentPermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentPermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * <p>
         * The permission type for the document. The permission type can be <i>Share</i>.
         * </p>
         * 
         * @param permissionType
         *        The permission type for the document. The permission type can be <i>Share</i>.
         * @see DocumentPermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentPermissionType
         */
        Builder permissionType(DocumentPermissionType permissionType);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String permissionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionRequest model) {
            setName(model.name);
            setPermissionType(model.permissionType);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType.toString());
            return this;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        public final void setPermissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType.toString());
        }

        @Override
        public DescribeDocumentPermissionRequest build() {
            return new DescribeDocumentPermissionRequest(this);
        }
    }
}
