/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMaintenanceWindowsResponse.Builder, DescribeMaintenanceWindowsResponse> {
    private final List<MaintenanceWindowIdentity> windowIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowsResponse(BuilderImpl builder) {
        this.windowIdentities = builder.windowIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the Maintenance Windows.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Maintenance Windows.
     */
    public List<MaintenanceWindowIdentity> windowIdentities() {
        return windowIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowIdentities() == null) ? 0 : windowIdentities().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowsResponse other = (DescribeMaintenanceWindowsResponse) obj;
        if (other.windowIdentities() == null ^ this.windowIdentities() == null) {
            return false;
        }
        if (other.windowIdentities() != null && !other.windowIdentities().equals(this.windowIdentities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowIdentities() != null) {
            sb.append("WindowIdentities: ").append(windowIdentities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMaintenanceWindowsResponse> {
        /**
         * <p>
         * Information about the Maintenance Windows.
         * </p>
         * 
         * @param windowIdentities
         *        Information about the Maintenance Windows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowIdentities(Collection<MaintenanceWindowIdentity> windowIdentities);

        /**
         * <p>
         * Information about the Maintenance Windows.
         * </p>
         * 
         * @param windowIdentities
         *        Information about the Maintenance Windows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowIdentities(MaintenanceWindowIdentity... windowIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MaintenanceWindowIdentity> windowIdentities;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowsResponse model) {
            setWindowIdentities(model.windowIdentities);
            setNextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowIdentity> getWindowIdentities() {
            return windowIdentities;
        }

        @Override
        public final Builder windowIdentities(Collection<MaintenanceWindowIdentity> windowIdentities) {
            this.windowIdentities = MaintenanceWindowIdentityListCopier.copy(windowIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(MaintenanceWindowIdentity... windowIdentities) {
            windowIdentities(Arrays.asList(windowIdentities));
            return this;
        }

        public final void setWindowIdentities(Collection<MaintenanceWindowIdentity> windowIdentities) {
            this.windowIdentities = MaintenanceWindowIdentityListCopier.copy(windowIdentities);
        }

        @SafeVarargs
        public final void setWindowIdentities(MaintenanceWindowIdentity... windowIdentities) {
            windowIdentities(Arrays.asList(windowIdentities));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowsResponse build() {
            return new DescribeMaintenanceWindowsResponse(this);
        }
    }
}
