/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.DocumentDefaultVersionDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A default version of a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DocumentDefaultVersionDescription implements StructuredPojo,
        ToCopyableBuilder<DocumentDefaultVersionDescription.Builder, DocumentDefaultVersionDescription> {
    private final String name;

    private final String defaultVersion;

    private DocumentDefaultVersionDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultVersion = builder.defaultVersion;
    }

    /**
     * <p>
     * The name of the document.
     * </p>
     * 
     * @return The name of the document.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The default version of the document.
     * </p>
     * 
     * @return The default version of the document.
     */
    public String defaultVersion() {
        return defaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((defaultVersion() == null) ? 0 : defaultVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDefaultVersionDescription)) {
            return false;
        }
        DocumentDefaultVersionDescription other = (DocumentDefaultVersionDescription) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.defaultVersion() == null ^ this.defaultVersion() == null) {
            return false;
        }
        if (other.defaultVersion() != null && !other.defaultVersion().equals(this.defaultVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (defaultVersion() != null) {
            sb.append("DefaultVersion: ").append(defaultVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentDefaultVersionDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DocumentDefaultVersionDescription> {
        /**
         * <p>
         * The name of the document.
         * </p>
         * 
         * @param name
         *        The name of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The default version of the document.
         * </p>
         * 
         * @param defaultVersion
         *        The default version of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(String defaultVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String defaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDefaultVersionDescription model) {
            setName(model.name);
            setDefaultVersion(model.defaultVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefaultVersion() {
            return defaultVersion;
        }

        @Override
        public final Builder defaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public DocumentDefaultVersionDescription build() {
            return new DocumentDefaultVersionDescription(this);
        }
    }
}
