/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.DocumentParameterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters specified in a System Manager document that execute on the server when the command is run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DocumentParameter implements StructuredPojo, ToCopyableBuilder<DocumentParameter.Builder, DocumentParameter> {
    private final String name;

    private final String type;

    private final String description;

    private final String defaultValue;

    private DocumentParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of parameter. The type can be either String or StringList.
     * </p>
     * 
     * @return The type of parameter. The type can be either String or StringList.
     * @see DocumentParameterType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * A description of what the parameter does, how to use it, the default value, and whether or not the parameter is
     * optional.
     * </p>
     * 
     * @return A description of what the parameter does, how to use it, the default value, and whether or not the
     *         parameter is optional.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If specified, the default values for the parameters. Parameters without a default value are required. Parameters
     * with a default value are optional.
     * </p>
     * 
     * @return If specified, the default values for the parameters. Parameters without a default value are required.
     *         Parameters with a default value are optional.
     */
    public String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((defaultValue() == null) ? 0 : defaultValue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentParameter)) {
            return false;
        }
        DocumentParameter other = (DocumentParameter) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        if (other.defaultValue() != null && !other.defaultValue().equals(this.defaultValue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (defaultValue() != null) {
            sb.append("DefaultValue: ").append(defaultValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DocumentParameter> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param name
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of parameter. The type can be either String or StringList.
         * </p>
         * 
         * @param type
         *        The type of parameter. The type can be either String or StringList.
         * @see DocumentParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentParameterType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of parameter. The type can be either String or StringList.
         * </p>
         * 
         * @param type
         *        The type of parameter. The type can be either String or StringList.
         * @see DocumentParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentParameterType
         */
        Builder type(DocumentParameterType type);

        /**
         * <p>
         * A description of what the parameter does, how to use it, the default value, and whether or not the parameter
         * is optional.
         * </p>
         * 
         * @param description
         *        A description of what the parameter does, how to use it, the default value, and whether or not the
         *        parameter is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If specified, the default values for the parameters. Parameters without a default value are required.
         * Parameters with a default value are optional.
         * </p>
         * 
         * @param defaultValue
         *        If specified, the default values for the parameters. Parameters without a default value are required.
         *        Parameters with a default value are optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String description;

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentParameter model) {
            setName(model.name);
            setType(model.type);
            setDescription(model.description);
            setDefaultValue(model.defaultValue);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentParameterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(DocumentParameterType type) {
            this.type(type.toString());
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public DocumentParameter build() {
            return new DocumentParameter(this);
        }
    }
}
