/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInventorySchemaResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInventorySchemaResponse.Builder, GetInventorySchemaResponse> {
    private final List<InventoryItemSchema> schemas;

    private final String nextToken;

    private GetInventorySchemaResponse(BuilderImpl builder) {
        this.schemas = builder.schemas;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Inventory schemas returned by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Inventory schemas returned by the request.
     */
    public List<InventoryItemSchema> schemas() {
        return schemas;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((schemas() == null) ? 0 : schemas().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventorySchemaResponse)) {
            return false;
        }
        GetInventorySchemaResponse other = (GetInventorySchemaResponse) obj;
        if (other.schemas() == null ^ this.schemas() == null) {
            return false;
        }
        if (other.schemas() != null && !other.schemas().equals(this.schemas())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (schemas() != null) {
            sb.append("Schemas: ").append(schemas()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInventorySchemaResponse> {
        /**
         * <p>
         * Inventory schemas returned by the request.
         * </p>
         * 
         * @param schemas
         *        Inventory schemas returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(Collection<InventoryItemSchema> schemas);

        /**
         * <p>
         * Inventory schemas returned by the request.
         * </p>
         * 
         * @param schemas
         *        Inventory schemas returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(InventoryItemSchema... schemas);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<InventoryItemSchema> schemas;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventorySchemaResponse model) {
            setSchemas(model.schemas);
            setNextToken(model.nextToken);
        }

        public final Collection<InventoryItemSchema> getSchemas() {
            return schemas;
        }

        @Override
        public final Builder schemas(Collection<InventoryItemSchema> schemas) {
            this.schemas = InventoryItemSchemaResultListCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(InventoryItemSchema... schemas) {
            schemas(Arrays.asList(schemas));
            return this;
        }

        public final void setSchemas(Collection<InventoryItemSchema> schemas) {
            this.schemas = InventoryItemSchemaResultListCopier.copy(schemas);
        }

        @SafeVarargs
        public final void setSchemas(InventoryItemSchema... schemas) {
            schemas(Arrays.asList(schemas));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInventorySchemaResponse build() {
            return new GetInventorySchemaResponse(this);
        }
    }
}
