/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetParametersRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetParametersRequest.Builder, GetParametersRequest> {
    private final List<String> names;

    private final Boolean withDecryption;

    private GetParametersRequest(BuilderImpl builder) {
        this.names = builder.names;
        this.withDecryption = builder.withDecryption;
    }

    /**
     * <p>
     * Names of the parameters for which you want to query information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Names of the parameters for which you want to query information.
     */
    public List<String> names() {
        return names;
    }

    /**
     * <p>
     * Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored
     * for String and StringList parameter types.
     * </p>
     * 
     * @return Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is
     *         ignored for String and StringList parameter types.
     */
    public Boolean withDecryption() {
        return withDecryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((names() == null) ? 0 : names().hashCode());
        hashCode = 31 * hashCode + ((withDecryption() == null) ? 0 : withDecryption().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersRequest)) {
            return false;
        }
        GetParametersRequest other = (GetParametersRequest) obj;
        if (other.names() == null ^ this.names() == null) {
            return false;
        }
        if (other.names() != null && !other.names().equals(this.names())) {
            return false;
        }
        if (other.withDecryption() == null ^ this.withDecryption() == null) {
            return false;
        }
        if (other.withDecryption() != null && !other.withDecryption().equals(this.withDecryption())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (names() != null) {
            sb.append("Names: ").append(names()).append(",");
        }
        if (withDecryption() != null) {
            sb.append("WithDecryption: ").append(withDecryption()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetParametersRequest> {
        /**
         * <p>
         * Names of the parameters for which you want to query information.
         * </p>
         * 
         * @param names
         *        Names of the parameters for which you want to query information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * Names of the parameters for which you want to query information.
         * </p>
         * 
         * @param names
         *        Names of the parameters for which you want to query information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is
         * ignored for String and StringList parameter types.
         * </p>
         * 
         * @param withDecryption
         *        Return decrypted secure string value. Return decrypted values for secure string parameters. This flag
         *        is ignored for String and StringList parameter types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withDecryption(Boolean withDecryption);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> names;

        private Boolean withDecryption;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersRequest model) {
            setNames(model.names);
            setWithDecryption(model.withDecryption);
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
        }

        @SafeVarargs
        public final void setNames(String... names) {
            names(Arrays.asList(names));
        }

        public final Boolean getWithDecryption() {
            return withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        @Override
        public GetParametersRequest build() {
            return new GetParametersRequest(this);
        }
    }
}
