/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPatchBaselineResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetPatchBaselineResponse.Builder, GetPatchBaselineResponse> {
    private final String baselineId;

    private final String name;

    private final PatchFilterGroup globalFilters;

    private final PatchRuleGroup approvalRules;

    private final List<String> approvedPatches;

    private final List<String> rejectedPatches;

    private final List<String> patchGroups;

    private final Instant createdDate;

    private final Instant modifiedDate;

    private final String description;

    private GetPatchBaselineResponse(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.rejectedPatches = builder.rejectedPatches;
        this.patchGroups = builder.patchGroups;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the retrieved patch baseline.
     * </p>
     * 
     * @return The ID of the retrieved patch baseline.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch baseline.
     * </p>
     * 
     * @return The name of the patch baseline.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A set of global filters used to exclude patches from the baseline.
     * </p>
     * 
     * @return A set of global filters used to exclude patches from the baseline.
     */
    public PatchFilterGroup globalFilters() {
        return globalFilters;
    }

    /**
     * <p>
     * A set of rules used to include patches in the baseline.
     * </p>
     * 
     * @return A set of rules used to include patches in the baseline.
     */
    public PatchRuleGroup approvalRules() {
        return approvalRules;
    }

    /**
     * <p>
     * A list of explicitly approved patches for the baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of explicitly approved patches for the baseline.
     */
    public List<String> approvedPatches() {
        return approvedPatches;
    }

    /**
     * <p>
     * A list of explicitly rejected patches for the baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of explicitly rejected patches for the baseline.
     */
    public List<String> rejectedPatches() {
        return rejectedPatches;
    }

    /**
     * <p>
     * Patch groups included in the patch baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Patch groups included in the patch baseline.
     */
    public List<String> patchGroups() {
        return patchGroups;
    }

    /**
     * <p>
     * The date the patch baseline was created.
     * </p>
     * 
     * @return The date the patch baseline was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date the patch baseline was last modified.
     * </p>
     * 
     * @return The date the patch baseline was last modified.
     */
    public Instant modifiedDate() {
        return modifiedDate;
    }

    /**
     * <p>
     * A description of the patch baseline.
     * </p>
     * 
     * @return A description of the patch baseline.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((baselineId() == null) ? 0 : baselineId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((globalFilters() == null) ? 0 : globalFilters().hashCode());
        hashCode = 31 * hashCode + ((approvalRules() == null) ? 0 : approvalRules().hashCode());
        hashCode = 31 * hashCode + ((approvedPatches() == null) ? 0 : approvedPatches().hashCode());
        hashCode = 31 * hashCode + ((rejectedPatches() == null) ? 0 : rejectedPatches().hashCode());
        hashCode = 31 * hashCode + ((patchGroups() == null) ? 0 : patchGroups().hashCode());
        hashCode = 31 * hashCode + ((createdDate() == null) ? 0 : createdDate().hashCode());
        hashCode = 31 * hashCode + ((modifiedDate() == null) ? 0 : modifiedDate().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineResponse)) {
            return false;
        }
        GetPatchBaselineResponse other = (GetPatchBaselineResponse) obj;
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.globalFilters() == null ^ this.globalFilters() == null) {
            return false;
        }
        if (other.globalFilters() != null && !other.globalFilters().equals(this.globalFilters())) {
            return false;
        }
        if (other.approvalRules() == null ^ this.approvalRules() == null) {
            return false;
        }
        if (other.approvalRules() != null && !other.approvalRules().equals(this.approvalRules())) {
            return false;
        }
        if (other.approvedPatches() == null ^ this.approvedPatches() == null) {
            return false;
        }
        if (other.approvedPatches() != null && !other.approvedPatches().equals(this.approvedPatches())) {
            return false;
        }
        if (other.rejectedPatches() == null ^ this.rejectedPatches() == null) {
            return false;
        }
        if (other.rejectedPatches() != null && !other.rejectedPatches().equals(this.rejectedPatches())) {
            return false;
        }
        if (other.patchGroups() == null ^ this.patchGroups() == null) {
            return false;
        }
        if (other.patchGroups() != null && !other.patchGroups().equals(this.patchGroups())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.modifiedDate() == null ^ this.modifiedDate() == null) {
            return false;
        }
        if (other.modifiedDate() != null && !other.modifiedDate().equals(this.modifiedDate())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (baselineId() != null) {
            sb.append("BaselineId: ").append(baselineId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (globalFilters() != null) {
            sb.append("GlobalFilters: ").append(globalFilters()).append(",");
        }
        if (approvalRules() != null) {
            sb.append("ApprovalRules: ").append(approvalRules()).append(",");
        }
        if (approvedPatches() != null) {
            sb.append("ApprovedPatches: ").append(approvedPatches()).append(",");
        }
        if (rejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(rejectedPatches()).append(",");
        }
        if (patchGroups() != null) {
            sb.append("PatchGroups: ").append(patchGroups()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (modifiedDate() != null) {
            sb.append("ModifiedDate: ").append(modifiedDate()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetPatchBaselineResponse> {
        /**
         * <p>
         * The ID of the retrieved patch baseline.
         * </p>
         * 
         * @param baselineId
         *        The ID of the retrieved patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch baseline.
         * </p>
         * 
         * @param name
         *        The name of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A set of global filters used to exclude patches from the baseline.
         * </p>
         * 
         * @param globalFilters
         *        A set of global filters used to exclude patches from the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalFilters(PatchFilterGroup globalFilters);

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * 
         * @param approvalRules
         *        A set of rules used to include patches in the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRules(PatchRuleGroup approvalRules);

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(Collection<String> approvedPatches);

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(String... approvedPatches);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(Collection<String> rejectedPatches);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(String... rejectedPatches);

        /**
         * <p>
         * Patch groups included in the patch baseline.
         * </p>
         * 
         * @param patchGroups
         *        Patch groups included in the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroups(Collection<String> patchGroups);

        /**
         * <p>
         * Patch groups included in the patch baseline.
         * </p>
         * 
         * @param patchGroups
         *        Patch groups included in the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroups(String... patchGroups);

        /**
         * <p>
         * The date the patch baseline was created.
         * </p>
         * 
         * @param createdDate
         *        The date the patch baseline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date the patch baseline was last modified.
         * </p>
         * 
         * @param modifiedDate
         *        The date the patch baseline was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedDate(Instant modifiedDate);

        /**
         * <p>
         * A description of the patch baseline.
         * </p>
         * 
         * @param description
         *        A description of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    private static final class BuilderImpl implements Builder {
        private String baselineId;

        private String name;

        private PatchFilterGroup globalFilters;

        private PatchRuleGroup approvalRules;

        private List<String> approvedPatches;

        private List<String> rejectedPatches;

        private List<String> patchGroups;

        private Instant createdDate;

        private Instant modifiedDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineResponse model) {
            setBaselineId(model.baselineId);
            setName(model.name);
            setGlobalFilters(model.globalFilters);
            setApprovalRules(model.approvalRules);
            setApprovedPatches(model.approvedPatches);
            setRejectedPatches(model.rejectedPatches);
            setPatchGroups(model.patchGroups);
            setCreatedDate(model.createdDate);
            setModifiedDate(model.modifiedDate);
            setDescription(model.description);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PatchFilterGroup getGlobalFilters() {
            return globalFilters;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
        }

        public final PatchRuleGroup getApprovalRules() {
            return approvalRules;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
        }

        public final Collection<String> getApprovedPatches() {
            return approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String... approvedPatches) {
            approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        @SafeVarargs
        public final void setApprovedPatches(String... approvedPatches) {
            approvedPatches(Arrays.asList(approvedPatches));
        }

        public final Collection<String> getRejectedPatches() {
            return rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String... rejectedPatches) {
            rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        @SafeVarargs
        public final void setRejectedPatches(String... rejectedPatches) {
            rejectedPatches(Arrays.asList(rejectedPatches));
        }

        public final Collection<String> getPatchGroups() {
            return patchGroups;
        }

        @Override
        public final Builder patchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchGroups(String... patchGroups) {
            patchGroups(Arrays.asList(patchGroups));
            return this;
        }

        public final void setPatchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
        }

        @SafeVarargs
        public final void setPatchGroups(String... patchGroups) {
            patchGroups(Arrays.asList(patchGroups));
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public GetPatchBaselineResponse build() {
            return new GetPatchBaselineResponse(this);
        }
    }
}
