/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InstanceAggregatedAssociationOverviewMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information about the aggregated associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceAggregatedAssociationOverview implements StructuredPojo,
        ToCopyableBuilder<InstanceAggregatedAssociationOverview.Builder, InstanceAggregatedAssociationOverview> {
    private final String detailedStatus;

    private final Map<String, Integer> instanceAssociationStatusAggregatedCount;

    private InstanceAggregatedAssociationOverview(BuilderImpl builder) {
        this.detailedStatus = builder.detailedStatus;
        this.instanceAssociationStatusAggregatedCount = builder.instanceAssociationStatusAggregatedCount;
    }

    /**
     * <p>
     * Detailed status information about the aggregated associations.
     * </p>
     * 
     * @return Detailed status information about the aggregated associations.
     */
    public String detailedStatus() {
        return detailedStatus;
    }

    /**
     * <p>
     * The number of associations for the instance(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The number of associations for the instance(s).
     */
    public Map<String, Integer> instanceAssociationStatusAggregatedCount() {
        return instanceAssociationStatusAggregatedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((detailedStatus() == null) ? 0 : detailedStatus().hashCode());
        hashCode = 31
                * hashCode
                + ((instanceAssociationStatusAggregatedCount() == null) ? 0 : instanceAssociationStatusAggregatedCount()
                        .hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAggregatedAssociationOverview)) {
            return false;
        }
        InstanceAggregatedAssociationOverview other = (InstanceAggregatedAssociationOverview) obj;
        if (other.detailedStatus() == null ^ this.detailedStatus() == null) {
            return false;
        }
        if (other.detailedStatus() != null && !other.detailedStatus().equals(this.detailedStatus())) {
            return false;
        }
        if (other.instanceAssociationStatusAggregatedCount() == null ^ this.instanceAssociationStatusAggregatedCount() == null) {
            return false;
        }
        if (other.instanceAssociationStatusAggregatedCount() != null
                && !other.instanceAssociationStatusAggregatedCount().equals(this.instanceAssociationStatusAggregatedCount())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (detailedStatus() != null) {
            sb.append("DetailedStatus: ").append(detailedStatus()).append(",");
        }
        if (instanceAssociationStatusAggregatedCount() != null) {
            sb.append("InstanceAssociationStatusAggregatedCount: ").append(instanceAssociationStatusAggregatedCount())
                    .append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAggregatedAssociationOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceAggregatedAssociationOverview> {
        /**
         * <p>
         * Detailed status information about the aggregated associations.
         * </p>
         * 
         * @param detailedStatus
         *        Detailed status information about the aggregated associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * The number of associations for the instance(s).
         * </p>
         * 
         * @param instanceAssociationStatusAggregatedCount
         *        The number of associations for the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAssociationStatusAggregatedCount(Map<String, Integer> instanceAssociationStatusAggregatedCount);
    }

    private static final class BuilderImpl implements Builder {
        private String detailedStatus;

        private Map<String, Integer> instanceAssociationStatusAggregatedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAggregatedAssociationOverview model) {
            setDetailedStatus(model.detailedStatus);
            setInstanceAssociationStatusAggregatedCount(model.instanceAssociationStatusAggregatedCount);
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Map<String, Integer> getInstanceAssociationStatusAggregatedCount() {
            return instanceAssociationStatusAggregatedCount;
        }

        @Override
        public final Builder instanceAssociationStatusAggregatedCount(
                Map<String, Integer> instanceAssociationStatusAggregatedCount) {
            this.instanceAssociationStatusAggregatedCount = InstanceAssociationStatusAggregatedCountCopier
                    .copy(instanceAssociationStatusAggregatedCount);
            return this;
        }

        public final void setInstanceAssociationStatusAggregatedCount(
                Map<String, Integer> instanceAssociationStatusAggregatedCount) {
            this.instanceAssociationStatusAggregatedCount = InstanceAssociationStatusAggregatedCountCopier
                    .copy(instanceAssociationStatusAggregatedCount);
        }

        @Override
        public InstanceAggregatedAssociationOverview build() {
            return new InstanceAggregatedAssociationOverview(this);
        }
    }
}
