/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InstanceInformationFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter for a specific list of instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceInformationFilter implements StructuredPojo,
        ToCopyableBuilder<InstanceInformationFilter.Builder, InstanceInformationFilter> {
    private final String key;

    private final List<String> valueSet;

    private InstanceInformationFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.valueSet = builder.valueSet;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * 
     * @return The name of the filter.
     * @see InstanceInformationFilterKey
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The filter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filter values.
     */
    public List<String> valueSet() {
        return valueSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((valueSet() == null) ? 0 : valueSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformationFilter)) {
            return false;
        }
        InstanceInformationFilter other = (InstanceInformationFilter) obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.valueSet() == null ^ this.valueSet() == null) {
            return false;
        }
        if (other.valueSet() != null && !other.valueSet().equals(this.valueSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (valueSet() != null) {
            sb.append("ValueSet: ").append(valueSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInformationFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceInformationFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @see InstanceInformationFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInformationFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @see InstanceInformationFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInformationFilterKey
         */
        Builder key(InstanceInformationFilterKey key);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param valueSet
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueSet(Collection<String> valueSet);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param valueSet
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueSet(String... valueSet);
    }

    private static final class BuilderImpl implements Builder {
        private String key;

        private List<String> valueSet;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformationFilter model) {
            setKey(model.key);
            setValueSet(model.valueSet);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(InstanceInformationFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final void setKey(InstanceInformationFilterKey key) {
            this.key(key.toString());
        }

        public final Collection<String> getValueSet() {
            return valueSet;
        }

        @Override
        public final Builder valueSet(Collection<String> valueSet) {
            this.valueSet = InstanceInformationFilterValueSetCopier.copy(valueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueSet(String... valueSet) {
            valueSet(Arrays.asList(valueSet));
            return this;
        }

        public final void setValueSet(Collection<String> valueSet) {
            this.valueSet = InstanceInformationFilterValueSetCopier.copy(valueSet);
        }

        @SafeVarargs
        public final void setValueSet(String... valueSet) {
            valueSet(Arrays.asList(valueSet));
        }

        @Override
        public InstanceInformationFilter build() {
            return new InstanceInformationFilter(this);
        }
    }
}
