/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InstancePatchStateFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a filter used in DescribeInstancePatchStatesForPatchGroup used to scope down the information returned by the
 * API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstancePatchStateFilter implements StructuredPojo,
        ToCopyableBuilder<InstancePatchStateFilter.Builder, InstancePatchStateFilter> {
    private final String key;

    private final List<String> values;

    private final String type;

    private InstancePatchStateFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.type = builder.type;
    }

    /**
     * <p>
     * The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount, MissingCount and
     * NotApplicableCount.
     * </p>
     * 
     * @return The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount,
     *         MissingCount and NotApplicableCount.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The value for the filter, must be an integer greater than or equal to 0.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value for the filter, must be an integer greater than or equal to 0.
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
     * </p>
     * 
     * @return The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
     * @see InstancePatchStateOperatorType
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((values() == null) ? 0 : values().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePatchStateFilter)) {
            return false;
        }
        InstancePatchStateFilter other = (InstancePatchStateFilter) obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.values() == null ^ this.values() == null) {
            return false;
        }
        if (other.values() != null && !other.values().equals(this.values())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (values() != null) {
            sb.append("Values: ").append(values()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePatchStateFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstancePatchStateFilter> {
        /**
         * <p>
         * The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount, MissingCount
         * and NotApplicableCount.
         * </p>
         * 
         * @param key
         *        The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount,
         *        MissingCount and NotApplicableCount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value for the filter, must be an integer greater than or equal to 0.
         * </p>
         * 
         * @param values
         *        The value for the filter, must be an integer greater than or equal to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value for the filter, must be an integer greater than or equal to 0.
         * </p>
         * 
         * @param values
         *        The value for the filter, must be an integer greater than or equal to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
         * </p>
         * 
         * @param type
         *        The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or
         *        GreaterThan.
         * @see InstancePatchStateOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstancePatchStateOperatorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
         * </p>
         * 
         * @param type
         *        The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or
         *        GreaterThan.
         * @see InstancePatchStateOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstancePatchStateOperatorType
         */
        Builder type(InstancePatchStateOperatorType type);
    }

    private static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePatchStateFilter model) {
            setKey(model.key);
            setValues(model.values);
            setType(model.type);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = InstancePatchStateFilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = InstancePatchStateFilterValuesCopier.copy(values);
        }

        @SafeVarargs
        public final void setValues(String... values) {
            values(Arrays.asList(values));
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InstancePatchStateOperatorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(InstancePatchStateOperatorType type) {
            this.type(type.toString());
        }

        @Override
        public InstancePatchStateFilter build() {
            return new InstancePatchStateFilter(this);
        }
    }
}
